/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.AbstractParametersExporterOutput;
import net.sf.jasperreports.export.parameters.StringBufferWrapperWriter;

public class ParametersWriterExporterOutput
extends AbstractParametersExporterOutput
implements WriterExporterOutput {
    protected String encoding;
    private Writer writer;
    private boolean toClose;

    public ParametersWriterExporterOutput(JasperReportsContext jasperReportsContext, Map<JRExporterParameter, Object> parameters, JasperPrint jasperPrint) {
        super(jasperReportsContext, parameters, jasperPrint);
        this.setEncoding();
        this.toClose = false;
        StringBuffer sb = (StringBuffer)parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb != null) {
            this.writer = new StringBufferWrapperWriter(sb);
            this.toClose = true;
        } else {
            this.writer = (Writer)parameters.get(JRExporterParameter.OUTPUT_WRITER);
            if (this.writer == null) {
                OutputStream os = (OutputStream)parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.getEncoding());
                    }
                    catch (IOException e) {
                        throw new JRRuntimeException(e);
                    }
                }
                File destFile = (File)parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRRuntimeException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.getEncoding());
                    this.toClose = true;
                }
                catch (IOException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
    }

    protected void setEncoding() {
        this.encoding = this.getParameterResolver().getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void close() {
        if (this.toClose) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

