/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.components.iconlabel.IconLabelComponent;
import net.sf.jasperreports.components.iconlabel.IconLabelComponentUtil;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluatorFactory;
import net.sf.jasperreports.crosstabs.CrosstabColumnCell;
import net.sf.jasperreports.crosstabs.CrosstabDeepVisitor;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.BucketExpressionOrderer;
import net.sf.jasperreports.crosstabs.fill.BucketOrderer;
import net.sf.jasperreports.crosstabs.fill.IconLabelFillObjectFactory;
import net.sf.jasperreports.crosstabs.fill.JRCrosstabExpressionEvaluator;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabCell;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabMeasure;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabObjectFactory;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingServiceContext;
import net.sf.jasperreports.crosstabs.fill.calculation.ColumnValueInfo;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabBucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.OrderByColumnInfo;
import net.sf.jasperreports.crosstabs.fill.calculation.OrderByColumnOrderer;
import net.sf.jasperreports.crosstabs.interactive.DataColumnInfo;
import net.sf.jasperreports.crosstabs.interactive.RowGroupInteractiveInfo;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillComponentElement;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.JRYXComparator;
import net.sf.jasperreports.engine.type.HorizontalPosition;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.web.util.JacksonUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillCrosstab
extends JRFillElement
implements JRCrosstab,
JROriginProvider,
BucketingServiceContext {
    private static final Log log = LogFactory.getLog(JRFillCrosstab.class);
    public static final String PROPERTY_INTERACTIVE = "net.sf.jasperreports.crosstab.interactive";
    public static final String PROPERTY_ORDER_BY_COLUMN = "net.sf.jasperreports.crosstab.order.by.column";
    public static final String PROPERTY_ROW_GROUP_COLUMN_HEADER = "net.sf.jasperreports.crosstab.row.group.column.header";
    public static final String PROPERTY_COLUMN_HEADER_SORT_MEASURE_INDEX = "net.sf.jasperreports.crosstab.column.header.sort.measure.index";
    public static final String CROSSTAB_INTERACTIVE_ELEMENT_NAME = "crosstabInteractiveElement";
    public static final JRGenericElementType CROSSTAB_INTERACTIVE_ELEMENT_TYPE = new JRGenericElementType("http://jasperreports.sourceforge.net/jasperreports", "crosstabInteractiveElement");
    protected static final String FILL_CACHE_KEY_CROSSTAB_CHUNK_COUNTER = JRFillCrosstab.class.getName() + "#chunkCounter";
    private final JRFillObjectFactory fillFactory;
    protected final JRCrosstab parentCrosstab;
    protected final JRLineBox lineBox;
    protected JRFillCrosstabDataset dataset;
    protected JRFillCrosstabRowGroup[] rowGroups;
    protected Map<String, Integer> rowGroupsMap;
    protected JRFillCrosstabColumnGroup[] columnGroups;
    protected Map<String, Integer> columnGroupsMap;
    protected JRFillCrosstabMeasure[] measures;
    private OrderByColumnInfo orderByColumnInfo;
    private List<BucketDefinition.Bucket> orderByColumnBucketValues;
    protected CrosstabBucketingService bucketingService;
    protected JRFillVariable[] variables;
    protected Map<String, JRFillVariable> variablesMap;
    protected JRFillVariable[][][] totalVariables;
    protected boolean[][] retrieveTotal;
    protected JRFillCrosstabParameter[] parameters;
    protected Map<String, JRFillParameter> parametersMap;
    protected boolean ignoreWidth;
    protected JRCrosstabExpressionEvaluator crosstabEvaluator;
    protected JRFillCrosstabCell[][] crossCells;
    protected JRFillCellContents titleCellContents;
    protected JRFillCellContents headerCell;
    protected JRFillCellContents whenNoDataCell;
    protected boolean hasData;
    protected HeaderCell[][] columnHeadersData;
    protected HeaderCell[][] rowHeadersData;
    protected CrosstabCell[][] cellData;
    protected MeasureDefinition.MeasureValue[] grandTotals;
    private boolean percentage;
    private CrosstabFiller crosstabFiller;
    private int overflowStartPage;
    private List<JRTemplatePrintFrame> printFrames;
    private boolean interactive;
    private int lastColumnGroupWithHeaderIndex = -1;

    public JRFillCrosstab(JRBaseFiller filler, JRCrosstab crosstab, JRFillObjectFactory factory) {
        super(filler, crosstab, factory);
        this.fillFactory = factory;
        this.parentCrosstab = crosstab;
        this.lineBox = crosstab.getLineBox().clone(this);
        this.loadEvaluator(filler.getJasperReport());
        JRFillCrosstabObjectFactory crosstabFactory = new JRFillCrosstabObjectFactory(factory, (JRFillExpressionEvaluator)this.crosstabEvaluator);
        crosstabFactory.setParentOriginProvider(this);
        if (crosstab.getTitleCell() != null && crosstab.getTitleCell().getCellContents() != null) {
            this.titleCellContents = crosstabFactory.getCell(crosstab.getTitleCell().getCellContents(), "CrosstabTitle");
        }
        this.headerCell = crosstabFactory.getCell(crosstab.getHeaderCell(), "CrosstabHeader");
        this.copyRowGroups(crosstab, crosstabFactory);
        this.copyColumnGroups(crosstab, crosstabFactory);
        this.copyMeasures(crosstab, crosstabFactory);
        this.copyCells(crosstab, crosstabFactory);
        this.whenNoDataCell = crosstabFactory.getCell(crosstab.getWhenNoDataCell(), "NoDataCell");
        this.dataset = factory.getCrosstabDataset(crosstab.getDataset(), this);
        this.crosstabEvaluator.setFillDataset(this.dataset.getFillDataset());
        this.copyParameters(crosstab, factory);
        this.copyVariables(crosstab, crosstabFactory);
        this.lastColumnGroupWithHeaderIndex = this.determineLastColumnGroupWithHeaderIndex();
        this.crosstabFiller = new CrosstabFiller();
    }

    @Override
    protected void setBand(JRFillBand band) {
        super.setBand(band);
        this.dataset.setBand(band);
    }

    private boolean isIgnoreWidth(JRBaseFiller filler, JRCrosstab crosstab) {
        Boolean crosstabIgnoreWidth = crosstab.getIgnoreWidth();
        if (crosstabIgnoreWidth != null) {
            return crosstabIgnoreWidth;
        }
        String reportProperty = filler.jasperReport.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.ignore.width");
        if (reportProperty != null) {
            return JRPropertiesUtil.asBoolean(reportProperty);
        }
        Boolean ignorePaginationParam = (Boolean)filler.getMasterFiller().getParameterValue("IS_IGNORE_PAGINATION");
        if (ignorePaginationParam != null && ignorePaginationParam.booleanValue()) {
            return ignorePaginationParam;
        }
        return filler.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.crosstab.ignore.width");
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    private void copyRowGroups(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        this.rowGroups = new JRFillCrosstabRowGroup[groups.length];
        this.rowGroupsMap = new HashMap<String, Integer>();
        for (int i = 0; i < groups.length; ++i) {
            JRFillCrosstabRowGroup group = factory.getCrosstabRowGroup(groups[i]);
            group.getFillHeader().setVerticalPositionType(groups[i].getPositionValue());
            this.rowGroups[i] = group;
            this.rowGroupsMap.put(group.getName(), i);
        }
    }

    private void copyColumnGroups(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        this.columnGroups = new JRFillCrosstabColumnGroup[groups.length];
        this.columnGroupsMap = new HashMap<String, Integer>();
        for (int i = 0; i < groups.length; ++i) {
            JRFillCrosstabColumnGroup group;
            this.columnGroups[i] = group = factory.getCrosstabColumnGroup(groups[i]);
            this.columnGroupsMap.put(group.getName(), i);
        }
    }

    private void copyMeasures(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabMeasure[] crossMeasures = crosstab.getMeasures();
        this.measures = new JRFillCrosstabMeasure[crossMeasures.length];
        for (int i = 0; i < crossMeasures.length; ++i) {
            this.measures[i] = factory.getCrosstabMeasure(crossMeasures[i]);
        }
    }

    private void copyParameters(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabParameter[] crossParams = crosstab.getParameters();
        this.parameters = new JRFillCrosstabParameter[crossParams.length];
        this.parametersMap = new HashMap<String, JRFillParameter>();
        for (int i = 0; i < crossParams.length; ++i) {
            this.parameters[i] = factory.getCrosstabParameter(crossParams[i]);
            this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
        }
    }

    private void copyCells(JRCrosstab crosstab, JRFillCrosstabObjectFactory factory) {
        JRCrosstabCell[][] crosstabCells = crosstab.getCells();
        this.crossCells = new JRFillCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
        for (int i = 0; i <= this.rowGroups.length; ++i) {
            for (int j = 0; j <= this.columnGroups.length; ++j) {
                if (crosstabCells[i][j] == null) continue;
                this.crossCells[i][j] = factory.getCrosstabCell(crosstabCells[i][j]);
            }
        }
    }

    private void copyVariables(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRVariable[] vars = crosstab.getVariables();
        this.variables = new JRFillVariable[vars.length];
        this.variablesMap = new HashMap<String, JRFillVariable>();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = factory.getVariable(vars[i]);
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
        HashMap<String, int[]> totalVarPos = new HashMap<String, int[]>();
        this.totalVariables = new JRFillVariable[this.rowGroups.length + 1][this.columnGroups.length + 1][this.measures.length];
        for (int row = 0; row <= this.rowGroups.length; ++row) {
            JRFillCrosstabRowGroup rowGroup = row == this.rowGroups.length ? null : this.rowGroups[row];
            for (int col = 0; col <= this.columnGroups.length; ++col) {
                JRFillCrosstabColumnGroup colGroup;
                JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup = colGroup = col == this.columnGroups.length ? null : this.columnGroups[col];
                if (row >= this.rowGroups.length && col >= this.columnGroups.length) continue;
                for (int m = 0; m < this.measures.length; ++m) {
                    String totalVariableName = JRDesignCrosstab.getTotalVariableName(this.measures[m], rowGroup, colGroup);
                    this.totalVariables[row][col][m] = this.variablesMap.get(totalVariableName);
                    totalVarPos.put(totalVariableName, new int[]{row, col});
                }
            }
        }
        HashSet<String> measureVars = new HashSet<String>();
        for (JRFillCrosstabMeasure measure : this.measures) {
            measureVars.add(measure.getFillVariable().getName());
        }
        this.retrieveTotal = new boolean[this.rowGroups.length + 1][this.columnGroups.length + 1];
        JRExpressionCollector collector = JRExpressionCollector.collector(this.filler.getJasperReportsContext(), this.filler.getJasperReport(), crosstab);
        List<JRExpression> expressions = collector.getExpressions(crosstab);
        for (JRExpression expression : expressions) {
            Object expressionContext = collector.getExpressionContext(expression);
            boolean groupHeaderExpression = expressionContext instanceof JRCrosstabGroup;
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks == null) continue;
            for (int i = 0; i < chunks.length; ++i) {
                JRExpressionChunk chunk = chunks[i];
                if (chunk.getType() != 4) continue;
                String varName = chunk.getText();
                int[] pos = (int[])totalVarPos.get(varName);
                if (pos != null) {
                    this.retrieveTotal[pos[0]][pos[1]] = true;
                }
                if (!groupHeaderExpression || pos == null && !measureVars.contains(varName)) continue;
                this.retrieveTotal[0][0] = true;
            }
        }
    }

    @Override
    public JRBaseFiller getFiller() {
        return this.filler;
    }

    protected void loadEvaluator(JasperReport jasperReport) {
        try {
            JREvaluator evaluator = JasperCompileManager.getInstance(this.filler.getJasperReportsContext()).getEvaluator(jasperReport, this.parentCrosstab);
            this.crosstabEvaluator = new JRCrosstabExpressionEvaluator(evaluator);
        }
        catch (JRException e) {
            throw new JRRuntimeException("Could not load evaluator for crosstab.", e);
        }
    }

    private CrosstabBucketingService createService(byte evaluation) throws JRException {
        boolean hasOrderByExpression = false;
        ArrayList<BucketDefinition> rowBuckets = new ArrayList<BucketDefinition>(this.rowGroups.length);
        for (int i = 0; i < this.rowGroups.length; ++i) {
            JRFillCrosstabRowGroup group = this.rowGroups[i];
            rowBuckets.add(this.createServiceBucket(group, i, evaluation));
            hasOrderByExpression |= group.getBucket().getOrderByExpression() != null;
        }
        ArrayList<BucketDefinition> colBuckets = new ArrayList<BucketDefinition>(this.columnGroups.length);
        for (int i = 0; i < this.columnGroups.length; ++i) {
            JRFillCrosstabColumnGroup group = this.columnGroups[i];
            colBuckets.add(this.createServiceBucket(group, i, evaluation));
            hasOrderByExpression |= group.getBucket().getOrderByExpression() != null;
        }
        this.percentage = false;
        ArrayList<MeasureDefinition> measureList = new ArrayList<MeasureDefinition>(this.measures.length);
        for (int i = 0; i < this.measures.length; ++i) {
            measureList.add(this.createServiceMeasure(this.measures[i]));
            this.percentage |= this.measures[i].getPercentageType() == CrosstabPercentageEnum.GRAND_TOTAL;
        }
        if (this.percentage || hasOrderByExpression) {
            ((BucketDefinition)rowBuckets.get(0)).setComputeTotal();
            ((BucketDefinition)colBuckets.get(0)).setComputeTotal();
        }
        return new CrosstabBucketingService(this, rowBuckets, colBuckets, measureList, this.dataset.isDataPreSorted(), this.retrieveTotal);
    }

    private BucketDefinition createServiceBucket(JRCrosstabGroup group, int groupIndex, byte evaluation) throws JRException {
        JRCrosstabBucket bucket = group.getBucket();
        Comparator comparator = null;
        JRExpression comparatorExpression = bucket.getComparatorExpression();
        if (comparatorExpression != null) {
            comparator = (Comparator)this.evaluateExpression(comparatorExpression, evaluation);
        }
        BucketOrderer orderer = this.createOrderer(group, groupIndex, comparator);
        return new BucketDefinition(bucket.getValueClass(), orderer, comparator, bucket.getOrder(), group.getTotalPositionValue());
    }

    protected BucketOrderer createOrderer(JRCrosstabGroup group, int groupIndex, Comparator<Object> bucketComparator) {
        JRCrosstabBucket bucket;
        JRExpression orderByExpression;
        BucketOrderer orderer = null;
        if (group instanceof JRCrosstabRowGroup && this.orderByColumnInfo != null && this.orderByColumnInfo.getOrder() != null && (groupIndex == this.rowGroups.length - 1 || group.getBucket().getOrder() == BucketOrder.NONE)) {
            orderer = new OrderByColumnOrderer(this.orderByColumnInfo);
        }
        if (orderer == null && (orderByExpression = (bucket = group.getBucket()).getOrderByExpression()) != null && bucket.getOrder() != BucketOrder.NONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("using order by expression to order group " + group.getName()));
            }
            Comparator<Object> orderValueComparator = BucketDefinition.createOrderComparator(bucketComparator, bucket.getOrder());
            orderer = new BucketExpressionOrderer(orderByExpression, orderValueComparator);
        }
        return orderer;
    }

    private MeasureDefinition createServiceMeasure(JRFillCrosstabMeasure measure) {
        return new MeasureDefinition(measure.getValueClass(), measure.getCalculationValue(), measure.getIncrementerFactory());
    }

    @Override
    public Object evaluateMeasuresExpression(JRExpression expression, MeasureDefinition.MeasureValue[] measureValues) throws JRException {
        for (int i = 0; i < this.measures.length; ++i) {
            Object value = measureValues[i].getValue();
            this.measures[i].getFillVariable().setValue(value);
        }
        return this.crosstabEvaluator.evaluate(expression, (byte)3);
    }

    @Override
    protected void reset() {
        super.reset();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].setValue(null);
            this.variables[i].setInitialized(true);
        }
        this.printFrames = null;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.evaluateProperties(evaluation);
            this.evaluateStyle(evaluation);
            this.dataset.evaluateDatasetRun(evaluation);
            this.initEvaluator(evaluation);
            this.bucketingService.processData();
            this.bucketingService.createCrosstab();
            this.hasData = this.bucketingService.hasData();
            if (this.hasData) {
                this.columnHeadersData = this.bucketingService.getColumnHeaders();
                this.rowHeadersData = this.bucketingService.getRowHeaders();
                this.cellData = this.bucketingService.getCrosstabCells();
                if (this.percentage) {
                    this.grandTotals = this.bucketingService.getGrandTotals();
                }
                this.crosstabFiller.initCrosstab();
            }
            this.overflowStartPage = 0;
            this.ignoreWidth = this.isIgnoreWidth(this.filler, this.parentCrosstab);
            this.interactive = this.filler.getPropertiesUtil().getBooleanProperty(this, PROPERTY_INTERACTIVE, true);
        }
    }

    protected void initEvaluator(byte evaluation) throws JRException {
        Map<String, Object> parameterValues = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), evaluation, true, false, false);
        ResourceBundle resBdl = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (resBdl == null) {
            JRFillParameter resourceBundleParam = this.filler.getParametersMap().get("REPORT_RESOURCE_BUNDLE");
            parameterValues.put("REPORT_RESOURCE_BUNDLE", resourceBundleParam.getValue());
        }
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        for (int i = 0; i < this.parameters.length; ++i) {
            Object value = parameterValues.get(this.parameters[i].getName());
            this.parameters[i].setValue(value);
        }
        this.crosstabEvaluator.init(this.parametersMap, this.variablesMap, this.filler.getWhenResourceMissingType());
    }

    protected void initBucketingService() {
        if (this.bucketingService == null) {
            this.setOrderByColumnInfo();
            try {
                this.bucketingService = this.createService((byte)3);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Could not create bucketing service", e);
            }
            this.setOrderByColumnBucketValues();
        } else {
            this.bucketingService.clear();
        }
    }

    protected void setOrderByColumnInfo() {
        this.orderByColumnInfo = null;
        String orderByProperty = this.parentCrosstab.getPropertiesMap().getProperty(PROPERTY_ORDER_BY_COLUMN);
        if (orderByProperty == null || orderByProperty.isEmpty()) {
            return;
        }
        this.orderByColumnInfo = JacksonUtil.getInstance(this.filler.getJasperReportsContext()).loadObject(orderByProperty, OrderByColumnInfo.class);
    }

    protected void setOrderByColumnBucketValues() {
        if (this.orderByColumnInfo != null && this.orderByColumnInfo.getOrder() != null) {
            OrderByColumnOrderer orderer = new OrderByColumnOrderer(this.orderByColumnInfo);
            orderer.init(this.bucketingService);
            this.orderByColumnBucketValues = orderer.getBucketValues();
        }
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        if (availableHeight < this.getRelativeY() + this.getHeight()) {
            this.setToPrint(false);
            return true;
        }
        if (isOverflow && this.crosstabFiller.ended() && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return false;
            }
        }
        if (isOverflow && this.isPrintWhenDetailOverflows()) {
            this.setReprinted(true);
        }
        this.printFrames = new ArrayList<JRTemplatePrintFrame>();
        this.crosstabFiller.fill(availableHeight - this.getRelativeY());
        if (!this.printFrames.isEmpty()) {
            this.overflowStartPage = 0;
        } else {
            int pageCount = this.filler.getCurrentPageCount();
            if (this.overflowStartPage == 0) {
                this.overflowStartPage = pageCount;
            } else if (pageCount >= this.overflowStartPage + 2) {
                throw new JRRuntimeException("Crosstab has not printed anything on 3 consecutive pages, likely infinite loop");
            }
        }
        boolean willOverflow = this.crosstabFiller.willOverflow();
        if (willOverflow) {
            this.setStretchHeight(availableHeight - this.getRelativeY());
        } else if (!this.printFrames.isEmpty()) {
            JRTemplatePrintFrame lastFrame = this.printFrames.get(this.printFrames.size() - 1);
            int usedHeight = lastFrame.getY() + lastFrame.getHeight();
            this.setStretchHeight(usedHeight);
        }
        return willOverflow;
    }

    protected void addCrosstabChunk(List<JRPrintElement> elements, int yOffset) {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplateFrame(), this.printElementOriginator);
        printFrame.setX(0);
        printFrame.setY(yOffset);
        Collections.sort(elements, new JRYXComparator());
        int xLimit = Integer.MIN_VALUE;
        int yLimit = Integer.MIN_VALUE;
        for (JRPrintElement element : elements) {
            if (element.getX() + element.getWidth() > xLimit) {
                xLimit = element.getX() + element.getWidth();
            }
            if (element.getY() + element.getHeight() <= yLimit) continue;
            yLimit = element.getY() + element.getHeight();
        }
        JRLineBox lineBox = this.getLineBox();
        int width = xLimit + lineBox.getLeftPadding() + lineBox.getRightPadding();
        printFrame.setWidth(width);
        HorizontalPosition position = this.concreteHorizontalPosition();
        switch (position) {
            case RIGHT: {
                if (width >= this.getWidth() && this.getRunDirectionValue() != RunDirectionEnum.RTL) break;
                printFrame.setX(this.getWidth() - width);
                break;
            }
            case CENTER: {
                if (width >= this.getWidth()) break;
                int centeredX = (this.getWidth() - width) / 2;
                printFrame.setX(centeredX);
                break;
            }
        }
        int height = yLimit + lineBox.getTopPadding() + lineBox.getBottomPadding();
        printFrame.setHeight(height);
        if (this.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.mirrorPrintElements(elements, xLimit);
        }
        int chunkIndex = this.getChunkIndex();
        String chunkId = this.getUUID().toString() + "." + chunkIndex;
        if (this.interactive) {
            printFrame.getPropertiesMap().setProperty("net.sf.jasperreports.export.crosstab.crosstabId", chunkId);
            JRTemplateGenericPrintElement genericElement = this.createInteractiveElement(chunkId);
            printFrame.addElement(genericElement);
        }
        printFrame.addElements(elements);
        this.printFrames.add(printFrame);
    }

    protected int getChunkIndex() {
        JRFillContext fillerContext = this.filler.getFillContext();
        AtomicInteger counter = (AtomicInteger)fillerContext.getFillCache(FILL_CACHE_KEY_CROSSTAB_CHUNK_COUNTER);
        if (counter == null) {
            counter = new AtomicInteger();
            fillerContext.setFillCache(FILL_CACHE_KEY_CROSSTAB_CHUNK_COUNTER, counter);
        }
        int chunkIndex = counter.getAndIncrement();
        return chunkIndex;
    }

    protected HorizontalPosition concreteHorizontalPosition() {
        HorizontalPosition position = this.getHorizontalPosition();
        if (position == null) {
            position = this.getRunDirectionValue() == RunDirectionEnum.RTL ? HorizontalPosition.RIGHT : HorizontalPosition.LEFT;
        }
        return position;
    }

    protected JRTemplateGenericPrintElement createInteractiveElement(String chunkId) {
        JRTemplateGenericElement genericElementTemplate = new JRTemplateGenericElement(this.getElementOrigin(), this.defaultStyleProvider, CROSSTAB_INTERACTIVE_ELEMENT_TYPE);
        JRTemplateGenericPrintElement genericElement = new JRTemplateGenericPrintElement(genericElementTemplate, this.printElementOriginator);
        genericElement.setX(0);
        genericElement.setY(0);
        genericElement.setWidth(1);
        genericElement.setHeight(1);
        genericElement.setParameterValue("crosstabId", this.getUUID().toString());
        genericElement.setParameterValue("crosstabFragmentId", chunkId);
        genericElement.setParameterValue("startColumnIndex", this.crosstabFiller.startColumnIndex);
        BucketDefinition[] rowBuckets = this.bucketingService.getRowBuckets();
        ArrayList<RowGroupInteractiveInfo> rowGroups = new ArrayList<RowGroupInteractiveInfo>(rowBuckets.length);
        for (BucketDefinition bucket : rowBuckets) {
            RowGroupInteractiveInfo groupInfo = new RowGroupInteractiveInfo();
            groupInfo.setSortable(true);
            BucketOrder order = this.bucketOrder(bucket);
            groupInfo.setOrder(order);
            rowGroups.add(groupInfo);
        }
        genericElement.setParameterValue("rowGroups", rowGroups);
        int dataColumnCount = this.crosstabFiller.lastColumnIndex - this.crosstabFiller.startColumnIndex;
        ArrayList<DataColumnInfo> dataColumns = new ArrayList<DataColumnInfo>(dataColumnCount);
        for (int colIdx = this.crosstabFiller.startColumnIndex; colIdx < this.crosstabFiller.lastColumnIndex; ++colIdx) {
            int sortMeasureIndex;
            List<BucketDefinition.Bucket> bucketValues = null;
            for (int level = this.columnHeadersData.length - 1; level >= 0 && bucketValues == null; --level) {
                HeaderCell header = this.columnHeadersData[level][colIdx];
                bucketValues = header == null ? null : this.bucketValuesList(header);
            }
            DataColumnInfo dataColumn = new DataColumnInfo();
            int n = this.measures.length <= 1 ? 0 : (sortMeasureIndex = this.crosstabFiller.dataColumnSortMeasures == null ? 0 : this.crosstabFiller.dataColumnSortMeasures[colIdx - this.crosstabFiller.startColumnIndex]);
            if (sortMeasureIndex >= 0) {
                dataColumn.setSortMeasureIndex(sortMeasureIndex);
                List<ColumnValueInfo> columnValues = this.toColumnValues(bucketValues);
                dataColumn.setColumnValues(columnValues);
            }
            BucketOrder columnOrder = null;
            if (this.orderByColumnBucketValues != null && this.orderByColumnBucketValues.equals(bucketValues)) {
                columnOrder = BucketOrder.fromSortOrderEnum(this.orderByColumnInfo.getOrder());
            }
            dataColumn.setOrder(columnOrder);
            dataColumns.add(dataColumn);
        }
        genericElement.setParameterValue("dataColumns", dataColumns);
        return genericElement;
    }

    protected BucketOrder bucketOrder(BucketDefinition bucket) {
        return this.dataset.isDataPreSorted() || bucket.getOrderer() != null ? BucketOrder.NONE : bucket.getOrder();
    }

    protected boolean matchesOrderByColumn(HeaderCell cell) {
        if (this.orderByColumnBucketValues == null) {
            return false;
        }
        List<BucketDefinition.Bucket> cellValues = this.bucketValuesList(cell);
        if (cellValues.size() > this.orderByColumnBucketValues.size()) {
            return false;
        }
        Iterator<BucketDefinition.Bucket> orderValueIt = this.orderByColumnBucketValues.iterator();
        for (BucketDefinition.Bucket cellValue : cellValues) {
            BucketDefinition.Bucket orderValue;
            if (cellValue.equals(orderValue = orderValueIt.next())) continue;
            return false;
        }
        return true;
    }

    protected List<BucketDefinition.Bucket> bucketValuesList(HeaderCell cell) {
        BucketDefinition.Bucket[] values = cell.getBucketValues();
        ArrayList<BucketDefinition.Bucket> valuesList = new ArrayList<BucketDefinition.Bucket>(values.length);
        for (BucketDefinition.Bucket bucket : values) {
            if (bucket == null) continue;
            valuesList.add(bucket);
        }
        return valuesList;
    }

    protected List<ColumnValueInfo> toColumnValues(List<BucketDefinition.Bucket> bucketValues) {
        ArrayList<ColumnValueInfo> columnValues = new ArrayList<ColumnValueInfo>(bucketValues.size());
        for (BucketDefinition.Bucket bucket : bucketValues) {
            if (bucket == null) continue;
            ColumnValueInfo columnValue = new ColumnValueInfo();
            if (bucket.isTotal()) {
                columnValue.setTotal(true);
            } else {
                Object value = bucket.getValue();
                if (value != null) {
                    String valueType = value.getClass().getName();
                    columnValue.setValueType(valueType);
                    columnValue.setValue(JRValueStringUtils.serialize(valueType, value));
                }
            }
            columnValues.add(columnValue);
        }
        return columnValues;
    }

    @Override
    protected JRPrintElement fill() {
        return null;
    }

    protected JRTemplateFrame getTemplateFrame() {
        return (JRTemplateFrame)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        JRTemplateFrame template = new JRTemplateFrame(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider());
        template.setElement(this);
        template.copyBox(this.getLineBox());
        return template;
    }

    @Override
    protected void rewind() {
        this.crosstabFiller.initCrosstab();
        this.overflowStartPage = 0;
    }

    protected List<? extends JRPrintElement> getPrintElements() {
        return this.printFrames;
    }

    protected void mirrorPrintElements(List<JRPrintElement> printElements, int width) {
        for (JRPrintElement element : printElements) {
            int mirrorX = width - element.getX() - element.getWidth();
            element.setX(mirrorX);
        }
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitCrosstab(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            new CrosstabDeepVisitor(visitor).deepVisitCrosstab(this);
        }
    }

    @Override
    public int getId() {
        return this.parentCrosstab.getId();
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    private int determineLastColumnGroupWithHeaderIndex() {
        int lastGroupIndex;
        JRCellContents header;
        int colGroupIdx;
        for (colGroupIdx = this.columnGroups.length - 1; colGroupIdx >= 0 && ((header = this.columnGroups[colGroupIdx].getHeader()) == null || header.getChildren().isEmpty()); --colGroupIdx) {
        }
        int n = lastGroupIndex = colGroupIdx >= 0 ? colGroupIdx : 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("last column group with header is " + lastGroupIndex));
        }
        return lastGroupIndex;
    }

    @Override
    public int getColumnBreakOffset() {
        return this.parentCrosstab.getColumnBreakOffset();
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.parentCrosstab.isRepeatColumnHeaders();
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.parentCrosstab.isRepeatRowHeaders();
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parentCrosstab.getParametersMapExpression();
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    @Override
    public CrosstabColumnCell getTitleCell() {
        return this.parentCrosstab.getTitleCell();
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.variables;
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.parentCrosstab.getRunDirectionValue();
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HorizontalPosition getHorizontalPosition() {
        return this.parentCrosstab.getHorizontalPosition();
    }

    @Override
    public void setHorizontalPosition(HorizontalPosition horizontalPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JROrigin getOrigin() {
        return this.getElementOrigin();
    }

    @Override
    public Boolean getIgnoreWidth() {
        return this.parentCrosstab.getIgnoreWidth();
    }

    @Override
    public void setIgnoreWidth(Boolean ignoreWidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIgnoreWidth(boolean ignoreWidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.parentCrosstab.getDefaultLineColor();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JasperReportsContext getJasperReportsContext() {
        return this.filler.getJasperReportsContext();
    }

    @Override
    public JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    protected class CrosstabFiller {
        private int yOffset;
        private int yChunkOffset;
        private boolean willOverflow;
        private int[] rowHeadersXOffsets;
        private boolean[] columnBreakable;
        private boolean[] rowBreakable;
        private int[] columnCount;
        private int[] rowCount;
        private int[] columnXOffsets;
        private boolean noDataCellPrinted;
        private boolean titlePrinted;
        private int startRowIndex;
        private int startColumnIndex;
        private int lastColumnIndex;
        private List<HeaderCell[]> columnHeaders;
        private List<List<JRPrintElement>> printRows;
        private int[] dataColumnSortMeasures;
        private HeaderCell[] spanHeaders;
        private int[] spanHeadersStart;
        private List<Integer> rowYs = new ArrayList<Integer>();
        private int rowIdx;
        private List<JRFillCellContents> preparedRow = new ArrayList<JRFillCellContents>();
        private int preparedRowHeight;
        private boolean printRowHeaders;
        private boolean printColumnHeaders;
        private JRFillVariable rowCountVar;
        private JRFillVariable colCountVar;

        protected CrosstabFiller() {
            this.setRowHeadersXOffsets();
            this.printRows = new ArrayList<List<JRPrintElement>>();
            this.rowCountVar = JRFillCrosstab.this.variablesMap.get("ROW_COUNT");
            this.colCountVar = JRFillCrosstab.this.variablesMap.get("COLUMN_COUNT");
        }

        protected void initCrosstab() {
            this.columnXOffsets = this.computeOffsets(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, true);
            this.columnBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, this.columnXOffsets, true, true);
            this.columnCount = this.computeCounts(JRFillCrosstab.this.columnHeadersData);
            int[] rowYOffsets = this.computeOffsets(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, false);
            this.rowBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, rowYOffsets, false, false);
            this.rowCount = this.computeCounts(JRFillCrosstab.this.rowHeadersData);
            this.spanHeaders = new HeaderCell[JRFillCrosstab.this.rowGroups.length - 1];
            this.spanHeadersStart = new int[JRFillCrosstab.this.rowGroups.length - 1];
            this.startRowIndex = 0;
            this.startColumnIndex = 0;
            this.lastColumnIndex = 0;
            this.noDataCellPrinted = false;
            this.titlePrinted = false;
        }

        protected void setRowHeadersXOffsets() {
            this.rowHeadersXOffsets = new int[JRFillCrosstab.this.rowGroups.length + 1];
            this.rowHeadersXOffsets[0] = 0;
            for (int i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                this.rowHeadersXOffsets[i + 1] = this.rowHeadersXOffsets[i] + JRFillCrosstab.this.rowGroups[i].getWidth();
            }
        }

        protected int[] computeOffsets(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, boolean width) {
            int[] offsets = new int[headersData[0].length + 1];
            offsets[0] = 0;
            for (int i = 0; i < headersData[0].length; ++i) {
                int size = 0;
                for (int j = groups.length - 1; j >= 0; --j) {
                    JRFillCellContents cell;
                    if (headersData[j][i] == null) continue;
                    JRFillCellContents jRFillCellContents = cell = headersData[j][i].isTotal() ? groups[j].getFillTotalHeader() : groups[j].getFillHeader();
                    size = cell == null ? 0 : (width ? cell.getWidth() : cell.getHeight());
                    break;
                }
                offsets[i + 1] = offsets[i] + size;
            }
            return offsets;
        }

        protected boolean[] computeBreakableHeaders(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, int[] offsets, boolean width, boolean startHeaders) {
            boolean[] breakable = new boolean[headersData[0].length];
            for (int i = 0; i < breakable.length; ++i) {
                breakable[i] = true;
            }
            for (int j = 0; j < groups.length; ++j) {
                JRFillCellContents fillHeader = groups[j].getFillHeader();
                if (fillHeader == null) continue;
                int size = width ? fillHeader.getWidth() : fillHeader.getHeight();
                for (int i = 0; i < headersData[0].length; ++i) {
                    int k;
                    HeaderCell header = headersData[j][i];
                    if (header == null || header.isTotal() || header.getLevelSpan() <= 1) continue;
                    int span = header.getLevelSpan();
                    if (startHeaders) {
                        for (k = i + 1; k < i + span && offsets[k] - offsets[i] < size; ++k) {
                            breakable[k] = false;
                        }
                    }
                    for (k = i + span - 1; k > i && offsets[i + span] - offsets[k] < size; --k) {
                        breakable[k] = false;
                    }
                }
            }
            return breakable;
        }

        private int[] computeCounts(HeaderCell[][] headersData) {
            int[] counts = new int[headersData[0].length];
            HeaderCell[] lastHeaders = headersData[headersData.length - 1];
            int c = 0;
            for (int i = 0; i < counts.length; ++i) {
                HeaderCell lastHeader = lastHeaders[i];
                if (lastHeader == null || !lastHeader.isTotal()) {
                    // empty if block
                }
                counts[i] = ++c;
            }
            return counts;
        }

        protected void fill(int availableHeight) throws JRException {
            this.printRows.clear();
            this.yOffset = 0;
            this.yChunkOffset = 0;
            this.willOverflow = false;
            this.fillVerticalCrosstab(availableHeight);
        }

        protected boolean willOverflow() {
            return this.willOverflow;
        }

        protected boolean ended() {
            return JRFillCrosstab.this.hasData ? this.startRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.startColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length : this.noDataCellPrinted;
        }

        protected void fillVerticalCrosstab(int availableHeight) throws JRException {
            boolean fillEnded;
            int lastRowIndex;
            int rowHeadersXOffset;
            JRLineBox lineBox = JRFillCrosstab.this.getLineBox();
            int padding = lineBox.getTopPadding() + lineBox.getBottomPadding();
            int contentsHeight = availableHeight - padding;
            if (contentsHeight < 0) {
                this.willOverflow = true;
                return;
            }
            if (!JRFillCrosstab.this.hasData) {
                this.fillNoDataCell(contentsHeight);
                if (!this.printRows.isEmpty()) {
                    this.addFilledRows();
                }
                return;
            }
            this.printRowHeaders = this.startColumnIndex == 0 || JRFillCrosstab.this.isRepeatRowHeaders();
            int n = rowHeadersXOffset = this.printRowHeaders ? this.rowHeadersXOffsets[JRFillCrosstab.this.rowGroups.length] : 0;
            if (this.startColumnIndex == this.lastColumnIndex) {
                int availableWidth = JRFillCrosstab.this.getWidth() - lineBox.getLeftPadding() - lineBox.getRightPadding();
                this.columnHeaders = this.getGroupHeaders(availableWidth - rowHeadersXOffset, this.columnXOffsets, this.columnBreakable, this.startColumnIndex, JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups);
                this.lastColumnIndex = this.startColumnIndex + this.columnHeaders.size();
                if (this.startColumnIndex == this.lastColumnIndex) {
                    throw new JRRuntimeException("Not enough space to render the crosstab.");
                }
            }
            List<JRPrintElement> titleRow = null;
            if (this.startRowIndex == 0 && this.startColumnIndex == 0 && JRFillCrosstab.this.titleCellContents != null && !this.titlePrinted) {
                titleRow = this.fillTitleCell(contentsHeight - this.yOffset);
                if (this.willOverflow) {
                    return;
                }
                this.titlePrinted = true;
            }
            if (JRFillCrosstab.this.interactive && JRFillCrosstab.this.measures.length > 1) {
                this.dataColumnSortMeasures = new int[this.lastColumnIndex - this.startColumnIndex];
                Arrays.fill(this.dataColumnSortMeasures, -1);
            }
            this.printColumnHeaders = this.startRowIndex == 0 || JRFillCrosstab.this.isRepeatColumnHeaders();
            List<List<JRPrintElement>> columnHeaderRows = null;
            if (this.printColumnHeaders) {
                columnHeaderRows = this.fillColumnHeaders(rowHeadersXOffset, contentsHeight - this.yOffset);
                if (this.willOverflow) {
                    if (titleRow != null) {
                        this.addPrintRow(titleRow);
                        this.addFilledRows();
                    }
                    return;
                }
            }
            if ((lastRowIndex = this.fillRows(rowHeadersXOffset, contentsHeight - this.yOffset)) == this.startRowIndex) {
                this.willOverflow = true;
                if (titleRow != null) {
                    this.addPrintRow(titleRow);
                    this.addFilledRows();
                }
                return;
            }
            if (titleRow != null) {
                this.addPrintRow(titleRow);
            }
            if (columnHeaderRows != null) {
                this.printRows.addAll(columnHeaderRows);
            }
            if (!this.printRows.isEmpty()) {
                this.addFilledRows();
            }
            if (lastRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length) {
                this.startColumnIndex = this.lastColumnIndex;
                if (this.startColumnIndex < JRFillCrosstab.this.columnHeadersData[0].length) {
                    lastRowIndex = 0;
                    this.startRowIndex = 0;
                    int yAdvance = this.yOffset + JRFillCrosstab.this.getColumnBreakOffset() + padding;
                    this.yChunkOffset += yAdvance;
                    int remainingHeight = availableHeight - yAdvance;
                    this.yOffset = 0;
                    this.fillVerticalCrosstab(remainingHeight);
                    return;
                }
            }
            boolean bl = fillEnded = lastRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.lastColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length;
            if (fillEnded) {
                JRFillCrosstab.this.setStretchHeight(this.yOffset);
            } else {
                JRFillCrosstab.this.setStretchHeight(availableHeight);
            }
            this.startRowIndex = lastRowIndex;
            this.willOverflow = !fillEnded;
        }

        protected void addFilledRows() {
            ArrayList<JRPrintElement> prints = new ArrayList<JRPrintElement>();
            for (List<JRPrintElement> rowPrints : this.printRows) {
                prints.addAll(rowPrints);
            }
            JRFillCrosstab.this.addCrosstabChunk(prints, this.yChunkOffset);
            this.printRows.clear();
        }

        protected List<HeaderCell[]> getGroupHeaders(int available, int[] offsets, boolean[] breakable, int firstIndex, HeaderCell[][] headersData, JRFillCrosstabGroup[] groups) {
            int j;
            int lastIndex;
            ArrayList<HeaderCell[]> headers = new ArrayList<HeaderCell[]>();
            int maxOffset = available + offsets[firstIndex];
            for (lastIndex = firstIndex; lastIndex < headersData[0].length && (JRFillCrosstab.this.ignoreWidth || offsets[lastIndex + 1] <= maxOffset); ++lastIndex) {
                HeaderCell[] groupHeaders = new HeaderCell[groups.length];
                for (j = 0; j < groups.length; ++j) {
                    groupHeaders[j] = headersData[j][lastIndex];
                }
                headers.add(groupHeaders);
            }
            if (lastIndex < headersData[0].length) {
                while (lastIndex > firstIndex && !breakable[lastIndex]) {
                    --lastIndex;
                    headers.remove(headers.size() - 1);
                }
            }
            if (lastIndex > firstIndex) {
                if (firstIndex > 0) {
                    HeaderCell[] firstHeaders = (HeaderCell[])headers.get(0);
                    for (j = 0; j < groups.length; ++j) {
                        int spanIndex;
                        HeaderCell header = headersData[j][firstIndex];
                        if (header != null || (spanIndex = this.getSpanIndex(firstIndex, j, headersData)) < 0) continue;
                        HeaderCell spanCell = headersData[j][spanIndex];
                        int headerEndIdx = spanCell.getLevelSpan() + spanIndex;
                        if (headerEndIdx > lastIndex) {
                            headerEndIdx = lastIndex;
                        }
                        firstHeaders[j] = HeaderCell.createLevelSpanCopy(spanCell, headerEndIdx - firstIndex);
                    }
                }
                if (lastIndex < headersData[0].length) {
                    for (int j2 = 0; j2 < groups.length; ++j2) {
                        int spanIndex;
                        HeaderCell header = headersData[j2][lastIndex];
                        if (header != null || (spanIndex = this.getSpanIndex(lastIndex, j2, headersData)) < firstIndex) continue;
                        HeaderCell spanCell = headersData[j2][spanIndex];
                        HeaderCell[] headerCells = (HeaderCell[])headers.get(spanIndex - firstIndex);
                        headerCells[j2] = HeaderCell.createLevelSpanCopy(spanCell, lastIndex - spanIndex);
                    }
                }
            }
            return headers;
        }

        protected int getSpanIndex(int i, int j, HeaderCell[][] headersData) {
            HeaderCell spanCell;
            int span;
            int spanIndex;
            for (spanIndex = i - 1; spanIndex >= 0 && headersData[j][spanIndex] == null; --spanIndex) {
            }
            if (spanIndex >= 0 && (span = (spanCell = headersData[j][spanIndex]).getLevelSpan()) > i - spanIndex) {
                return spanIndex;
            }
            return -1;
        }

        protected void fillNoDataCell(int availableHeight) throws JRException {
            if (JRFillCrosstab.this.whenNoDataCell == null) {
                this.noDataCellPrinted = true;
            } else if (availableHeight < JRFillCrosstab.this.whenNoDataCell.getHeight()) {
                this.willOverflow = true;
            } else {
                JRFillCrosstab.this.whenNoDataCell.evaluate((byte)3);
                JRFillCrosstab.this.whenNoDataCell.prepare(availableHeight);
                this.willOverflow = JRFillCrosstab.this.whenNoDataCell.willOverflow();
                if (!this.willOverflow) {
                    JRFillCrosstab.this.whenNoDataCell.setX(0);
                    JRFillCrosstab.this.whenNoDataCell.setY(0);
                    JRPrintFrame printCell = JRFillCrosstab.this.whenNoDataCell.fill();
                    ArrayList<JRPrintElement> noDataRow = new ArrayList<JRPrintElement>(1);
                    noDataRow.add(printCell);
                    this.addPrintRow(noDataRow);
                    this.yOffset += JRFillCrosstab.this.whenNoDataCell.getPrintHeight();
                    this.noDataCellPrinted = true;
                }
            }
        }

        protected List<List<JRPrintElement>> fillColumnHeaders(int rowHeadersXOffset, int availableHeight) throws JRException {
            List<List<JRPrintElement>> headerRows;
            JRFillCellContents[][] columnHeaderRows = new JRFillCellContents[JRFillCrosstab.this.columnGroups.length][this.lastColumnIndex - this.startColumnIndex + 2];
            this.rowYs.clear();
            this.rowYs.add(0);
            if (this.printRowHeaders && JRFillCrosstab.this.headerCell != null) {
                JRFillCellContents contents = this.fillHeader(availableHeight);
                if (this.willOverflow) {
                    return null;
                }
                columnHeaderRows[JRFillCrosstab.this.columnGroups.length - 1][0] = contents;
            }
            this.rowIdx = 0;
            block0: while (this.rowIdx < JRFillCrosstab.this.columnGroups.length) {
                if (this.printRowHeaders) {
                    JRFillCellContents cell;
                    columnHeaderRows[this.rowIdx][1] = cell = this.prepareColumnCrosstabHeader(availableHeight);
                    if (this.willOverflow) break;
                }
                for (int columnIdx = this.startColumnIndex; columnIdx < this.lastColumnIndex; ++columnIdx) {
                    JRFillCellContents contents;
                    HeaderCell[] headers = this.columnHeaders.get(columnIdx - this.startColumnIndex);
                    HeaderCell cell = headers[this.rowIdx];
                    if (cell == null) continue;
                    columnHeaderRows[this.rowIdx + cell.getDepthSpan() - 1][columnIdx - this.startColumnIndex + 2] = contents = this.prepareColumnHeader(cell, this.rowIdx, columnIdx, rowHeadersXOffset, availableHeight);
                    if (this.willOverflow) break block0;
                }
                int rowStretchHeight = this.stretchColumnHeadersRow(columnHeaderRows[this.rowIdx]);
                this.rowYs.add(this.rowYs.get(this.rowIdx) + rowStretchHeight);
                ++this.rowIdx;
            }
            if (this.willOverflow) {
                headerRows = null;
                this.releaseColumnHeaderCells(columnHeaderRows);
            } else {
                headerRows = this.fillColumnHeaders(columnHeaderRows);
                Collections.reverse(headerRows);
                this.yOffset += this.rowYs.get(JRFillCrosstab.this.columnGroups.length).intValue();
            }
            this.resetVariables();
            return headerRows;
        }

        private void setCountVars(int rowIdx, int colIdx) {
            if (rowIdx == -1) {
                this.rowCountVar.setValue(null);
            } else {
                this.rowCountVar.setValue(this.rowCount[rowIdx]);
            }
            if (colIdx == -1) {
                this.colCountVar.setValue(null);
            } else {
                this.colCountVar.setValue(this.columnCount[colIdx]);
            }
        }

        private List<JRPrintElement> fillTitleCell(int availableHeight) throws JRException {
            this.setCountVars(-1, -1);
            JRFillCellContents cell = JRFillCrosstab.this.titleCellContents;
            int width = this.rowHeadersXOffsets[JRFillCrosstab.this.rowGroups.length] + this.columnXOffsets[this.lastColumnIndex] - this.columnXOffsets[this.startColumnIndex];
            cell = cell.getTransformedContents(width, cell.getHeight(), JRFillCrosstab.this.getTitleCell().getContentsPosition(), CrosstabRowPositionEnum.TOP);
            JRFillCellContents contents = cell.getWorkingClone();
            contents.evaluate((byte)3);
            contents.prepare(availableHeight);
            this.willOverflow = contents.willOverflow();
            if (this.willOverflow) {
                return null;
            }
            contents.setX(0);
            contents.setY(this.yOffset);
            contents.setHorizontalSpan(JRFillCrosstab.this.rowGroups.length + this.lastColumnIndex - this.startColumnIndex);
            contents.setVerticalSpan(1);
            JRPrintFrame printCell = contents.fill();
            ArrayList<JRPrintElement> titleRow = new ArrayList<JRPrintElement>(1);
            titleRow.add(printCell);
            this.yOffset += contents.getPrintHeight();
            return titleRow;
        }

        private JRFillCellContents fillHeader(int availableHeight) throws JRException {
            this.setCountVars(-1, -1);
            JRFillCellContents cell = JRFillCrosstab.this.headerCell;
            if (!JRFillCrosstab.this.headerCell.getChildren().isEmpty() && JRFillCrosstab.this.interactive) {
                cell = this.decorateCellWithRowGroupIconLabel(cell);
            }
            JRFillCellContents contents = cell.getWorkingClone();
            contents.evaluate((byte)3);
            contents.prepare(availableHeight);
            this.willOverflow = contents.willOverflow();
            if (!this.willOverflow) {
                contents.setX(0);
                contents.setY(this.yOffset);
                contents.setVerticalSpan(JRFillCrosstab.this.columnGroups.length);
                contents.setHorizontalSpan(JRFillCrosstab.this.rowGroups.length);
            }
            return contents;
        }

        private JRFillCellContents decorateCellWithRowGroupIconLabel(JRFillCellContents cell) {
            List<JRChild> cellElements = cell.getChildren();
            BucketDefinition[] rowBuckets = JRFillCrosstab.this.bucketingService.getRowBuckets();
            int[] headerTextIndices = new int[rowBuckets.length];
            boolean[] alignedText = new boolean[rowBuckets.length];
            boolean foundHeader = false;
            int bucketXOffset = 0;
            for (int bucketIdx = 0; bucketIdx < rowBuckets.length; ++bucketIdx) {
                int headerIndex = this.findRowGroupColumHeaderElementIndex(bucketIdx, cellElements);
                if (headerIndex >= 0) {
                    JRElement headerElement = (JRElement)cellElements.get(headerIndex);
                    boolean aligned = headerElement.getX() == bucketXOffset && headerElement.getWidth() == JRFillCrosstab.this.rowGroups[bucketIdx].getWidth();
                    BucketDefinition rowBucket = rowBuckets[bucketIdx];
                    if (JRFillCrosstab.this.bucketOrder(rowBucket) == BucketOrder.NONE && !aligned) {
                        headerTextIndices[bucketIdx] = -1;
                    } else {
                        headerTextIndices[bucketIdx] = headerIndex;
                        alignedText[bucketIdx] = aligned;
                        foundHeader = true;
                    }
                }
                bucketXOffset += JRFillCrosstab.this.rowGroups[bucketIdx].getWidth();
            }
            if (!foundHeader) {
                return cell;
            }
            JRFillCellContents decoratedCell = (JRFillCellContents)cell.createClone();
            List<JRChild> clonedElements = decoratedCell.getChildren();
            BuiltinExpressionEvaluatorFactory builtinExpressions = new BuiltinExpressionEvaluatorFactory();
            JRFillExpressionEvaluator decoratedEvaluator = builtinExpressions.decorate(cell.expressionEvaluator);
            TreeMap<Integer, JRDesignComponentElement> iconLabelElements = new TreeMap<Integer, JRDesignComponentElement>();
            for (int bucketIdx = 0; bucketIdx < headerTextIndices.length; ++bucketIdx) {
                int textElementIndex = headerTextIndices[bucketIdx];
                if (textElementIndex < 0) continue;
                JRFillTextElement textElement = (JRFillTextElement)clonedElements.get(textElementIndex);
                BucketOrder bucketOrder = JRFillCrosstab.this.bucketOrder(rowBuckets[bucketIdx]);
                if (bucketOrder == BucketOrder.NONE) {
                    if (!alignedText[bucketIdx]) continue;
                    textElement.setExpressionEvaluator(decoratedEvaluator);
                    textElement.addDynamicProperty("net.sf.jasperreports.export.crosstab.columnIndex", builtinExpressions.createConstantExpression(Integer.toString(bucketIdx)));
                    textElement.addDynamicProperty("net.sf.jasperreports.export.html.class", builtinExpressions.createConstantExpression("jrxtrowheader jrxtinteractive"));
                    continue;
                }
                textElement.setExpressionEvaluator(decoratedEvaluator);
                textElement.addDynamicProperty("net.sf.jasperreports.export.matcher.filter.key", builtinExpressions.createConstantExpression("net.sf.jasperreports.components.table.header.label"));
                SortOrderEnum order = BucketOrder.toSortOrderEnum(bucketOrder);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("wrapping header element " + textElement.getUUID() + " in iconLabel for row group " + bucketIdx));
                }
                JRDesignComponentElement iconLabelElement = this.createIconLabelElement(order, textElement, builtinExpressions);
                if (alignedText[bucketIdx]) {
                    iconLabelElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.crosstab.columnIndex", Integer.toString(bucketIdx));
                    iconLabelElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", "jrxtrowheader jrxtinteractive");
                }
                iconLabelElements.put(textElementIndex, iconLabelElement);
            }
            IconLabelFillObjectFactory factory = new IconLabelFillObjectFactory(JRFillCrosstab.this.fillFactory, decoratedEvaluator);
            for (Map.Entry entry : iconLabelElements.descendingMap().entrySet()) {
                int elementIndex = (Integer)entry.getKey();
                JRDesignComponentElement iconLabelElement = (JRDesignComponentElement)entry.getValue();
                JRFillComponentElement fillIconLabelElement = new JRFillComponentElement(JRFillCrosstab.this.filler, iconLabelElement, (JRFillObjectFactory)factory);
                decoratedCell.addElement(elementIndex + 1, fillIconLabelElement);
            }
            return decoratedCell;
        }

        private int findRowGroupColumHeaderElementIndex(int rowGroupIndex, List<JRChild> cellElements) {
            String rowGropIndexStr = Integer.toString(rowGroupIndex);
            int colHeaderTextIndex = -1;
            ListIterator<JRChild> elemIt = cellElements.listIterator(cellElements.size());
            while (elemIt.hasPrevious()) {
                JRFillTextElement textElement;
                JRElement parentElement;
                String prop;
                JRChild child = elemIt.previous();
                if (!(child instanceof JRTextElement) || (prop = (parentElement = (textElement = (JRFillTextElement)child).getParent()).hasProperties() ? parentElement.getPropertiesMap().getProperty(JRFillCrosstab.PROPERTY_ROW_GROUP_COLUMN_HEADER) : null) == null || !prop.equals(rowGropIndexStr)) continue;
                colHeaderTextIndex = elemIt.nextIndex();
                break;
            }
            return colHeaderTextIndex;
        }

        private JRFillCellContents prepareColumnHeader(HeaderCell cell, int rowIdx, int columnIdx, int xOffset, int availableHeight) throws JRException {
            JRFillCrosstabColumnGroup group = JRFillCrosstab.this.columnGroups[rowIdx];
            JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            int width = this.columnXOffsets[columnIdx + cell.getLevelSpan()] - this.columnXOffsets[columnIdx];
            int height = contents.getHeight();
            if (width <= 0 || height <= 0) {
                return null;
            }
            boolean headerLabel = rowIdx + cell.getDepthSpan() == JRFillCrosstab.this.lastColumnGroupWithHeaderIndex + 1 && cell.getLevelSpan() == 1;
            boolean header = rowIdx + cell.getDepthSpan() >= JRFillCrosstab.this.lastColumnGroupWithHeaderIndex + 1 && cell.getLevelSpan() == 1;
            JRFillCellContents preparedContents = null;
            int rowY = this.rowYs.get(rowIdx);
            if (availableHeight >= rowY + height) {
                this.setCountVars(-1, columnIdx);
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, cell.getBucketValues());
                this.setGroupMeasureVariables(cell, false);
                contents = contents.getTransformedContents(width, height, group.getPositionValue(), CrosstabRowPositionEnum.TOP);
                boolean firstOnRow = columnIdx == this.startColumnIndex && (!this.printRowHeaders || JRFillCrosstab.this.headerCell == null);
                contents = contents.getBoxContents(firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.LTR, firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.RTL, false);
                if (JRFillCrosstab.this.interactive && headerLabel && JRFillCrosstab.this.matchesOrderByColumn(cell)) {
                    contents = this.decorateWithSortIcon(contents, JRFillCrosstab.this.orderByColumnInfo.getOrder());
                }
                contents = contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - rowY);
                boolean sortHeader = false;
                if (JRFillCrosstab.this.interactive && headerLabel && JRFillCrosstab.this.measures.length > 1) {
                    if (JRFillCrosstab.this.measures.length <= 1) {
                        sortHeader = true;
                    } else {
                        int sortMeasureIdx;
                        this.dataColumnSortMeasures[columnIdx - this.startColumnIndex] = sortMeasureIdx = this.determineColumnSortMeasure(contents);
                        boolean bl = sortHeader = sortMeasureIdx >= 0;
                    }
                }
                if (JRFillCrosstab.this.interactive && header) {
                    contents.setPrintProperty("net.sf.jasperreports.export.crosstab.columnIndex", Integer.toString(columnIdx));
                    contents.setPrintProperty("net.sf.jasperreports.export.html.class", sortHeader ? "jrxtcolheader jrxtinteractive" : "jrxtcolheader");
                }
                if (contents.willOverflow()) {
                    this.willOverflow = true;
                } else {
                    contents.setX(this.columnXOffsets[columnIdx] - this.columnXOffsets[this.startColumnIndex] + xOffset);
                    contents.setY(rowY + this.yOffset);
                    contents.setVerticalSpan(cell.getDepthSpan());
                    contents.setHorizontalSpan(cell.getLevelSpan());
                    preparedContents = contents;
                }
            } else {
                this.willOverflow = true;
            }
            return preparedContents;
        }

        private int determineColumnSortMeasure(JRFillCellContents contents) {
            JRElement[] cellElements;
            int sortMeasureIdx = -1;
            for (JRElement element : cellElements = contents.getElements()) {
                String sortMeasureIdxProp;
                String string = sortMeasureIdxProp = element.hasProperties() ? element.getPropertiesMap().getProperty(JRFillCrosstab.PROPERTY_COLUMN_HEADER_SORT_MEASURE_INDEX) : null;
                if (sortMeasureIdxProp == null) continue;
                sortMeasureIdx = JRPropertiesUtil.asInteger(sortMeasureIdxProp);
                break;
            }
            return sortMeasureIdx;
        }

        private JRFillCellContents decorateWithSortIcon(JRFillCellContents cell, SortOrderEnum order) {
            JRElement[] elements = cell.getElements();
            if (elements.length != 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("order by column header has " + elements.length + " elements"));
                }
                return cell;
            }
            if (!(elements[0] instanceof JRTextElement)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("order by column header has element " + elements[0].getClass().getName()));
                }
                return cell;
            }
            JRFillTextElement textElement = (JRFillTextElement)elements[0];
            if (log.isDebugEnabled()) {
                log.debug((Object)("wrapping column header element " + textElement.getUUID() + " in iconLabel"));
            }
            BuiltinExpressionEvaluatorFactory builtinExpressions = new BuiltinExpressionEvaluatorFactory();
            JRDesignComponentElement iconLabelElement = this.createIconLabelElement(order, textElement, builtinExpressions);
            JRFillExpressionEvaluator decoratedEvaluator = builtinExpressions.decorate(cell.expressionEvaluator);
            IconLabelFillObjectFactory factory = new IconLabelFillObjectFactory(JRFillCrosstab.this.fillFactory, decoratedEvaluator);
            JRFillComponentElement fillIconLabelElement = new JRFillComponentElement(JRFillCrosstab.this.filler, iconLabelElement, (JRFillObjectFactory)factory);
            JRFillCellContents clonedCell = (JRFillCellContents)cell.createClone();
            clonedCell.addElement(1, fillIconLabelElement);
            JRFillElement clonedTextElement = (JRFillElement)clonedCell.getElements()[0];
            clonedTextElement.setExpressionEvaluator(decoratedEvaluator);
            clonedTextElement.addDynamicProperty("net.sf.jasperreports.export.matcher.filter.key", builtinExpressions.createConstantExpression("net.sf.jasperreports.components.table.header.label"));
            return clonedCell;
        }

        protected JRDesignComponentElement createIconLabelElement(SortOrderEnum order, JRFillTextElement textElement, BuiltinExpressionEvaluatorFactory builtinExpressions) {
            JRTextElement parentElement = (JRTextElement)textElement.getParent();
            JRDesignComponentElement designIconLabelElement = IconLabelComponentUtil.getInstance(JRFillCrosstab.this.filler.getJasperReportsContext()).createIconLabelComponentElement(parentElement, textElement);
            IconLabelComponent iconLabelComponent = (IconLabelComponent)designIconLabelElement.getComponent();
            JRDesignTextField labelTextField = (JRDesignTextField)iconLabelComponent.getLabelTextField();
            JRDesignTextField iconTextField = (JRDesignTextField)iconLabelComponent.getIconTextField();
            designIconLabelElement.setStyle(textElement.getInitStyle());
            labelTextField.setStyle(textElement.getInitStyle());
            iconTextField.setStyle(textElement.getInitStyle());
            if (textElement instanceof JRTextField) {
                labelTextField.setExpression(((JRTextField)((Object)textElement)).getExpression());
            } else if (textElement instanceof JRStaticText) {
                String text = ((JRStaticText)((Object)textElement)).getText();
                labelTextField.setExpression(builtinExpressions.createConstantExpression(text));
            }
            String iconText = order == SortOrderEnum.ASCENDING ? JRFillCrosstab.this.filler.getPropertiesUtil().getProperty("net.sf.jasperreports.components.sort.up.arrow.char") : (order == SortOrderEnum.DESCENDING ? JRFillCrosstab.this.filler.getPropertiesUtil().getProperty("net.sf.jasperreports.components.sort.down.arrow.char") : "");
            iconTextField.setExpression(builtinExpressions.createConstantExpression(" " + iconText));
            designIconLabelElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.matcher.filter.key", "net.sf.jasperreports.components.table.header.icon.label");
            return designIconLabelElement;
        }

        protected JRFillCellContents prepareColumnCrosstabHeader(int availableHeight) throws JRException {
            JRFillCellContents header = JRFillCrosstab.this.columnGroups[this.rowIdx].getFillCrosstabHeader();
            if (header == null) {
                return null;
            }
            int width = header.getWidth();
            int height = header.getHeight();
            if (width <= 0 || height <= 0) {
                return null;
            }
            int rowY = this.rowYs.get(this.rowIdx);
            if (availableHeight < rowY + height) {
                this.willOverflow = true;
                return null;
            }
            if (this.rowIdx == JRFillCrosstab.this.columnGroups.length - 1 && !header.getChildren().isEmpty() && JRFillCrosstab.this.interactive) {
                header = this.decorateCellWithRowGroupIconLabel(header);
            }
            JRFillCellContents preparedCell = header.getWorkingClone();
            this.setCountVars(-1, -1);
            preparedCell.evaluate((byte)3);
            preparedCell.prepare(availableHeight - rowY);
            if (preparedCell.willOverflow()) {
                this.willOverflow = true;
                return null;
            }
            preparedCell.setX(0);
            preparedCell.setY(rowY + this.yOffset);
            preparedCell.setHorizontalSpan(JRFillCrosstab.this.rowGroups.length);
            preparedCell.setVerticalSpan(1);
            return preparedCell;
        }

        private int stretchColumnHeadersRow(JRFillCellContents[] headers) {
            int startRowY;
            JRFillCellContents contents;
            int j;
            int rowY = this.rowYs.get(this.rowIdx);
            int rowStretchHeight = 0;
            for (j = 0; j < headers.length; ++j) {
                int height;
                contents = headers[j];
                if (contents == null) continue;
                startRowY = rowY;
                if (contents.getVerticalSpan() > 1) {
                    startRowY = this.rowYs.get(this.rowIdx - contents.getVerticalSpan() + 1);
                }
                if ((height = contents.getPrintHeight() - rowY + startRowY) <= rowStretchHeight) continue;
                rowStretchHeight = height;
            }
            for (j = 0; j < headers.length; ++j) {
                contents = headers[j];
                if (contents == null) continue;
                startRowY = rowY;
                if (contents.getVerticalSpan() > 1) {
                    startRowY = this.rowYs.get(this.rowIdx - contents.getVerticalSpan() + 1);
                }
                contents.stretchTo(rowStretchHeight + rowY - startRowY);
            }
            return rowStretchHeight;
        }

        private List<List<JRPrintElement>> fillColumnHeaders(JRFillCellContents[][] columnHeaderRows) throws JRException {
            ArrayList<List<JRPrintElement>> headerRows = new ArrayList<List<JRPrintElement>>(JRFillCrosstab.this.columnGroups.length);
            for (int i = 0; i < columnHeaderRows.length; ++i) {
                ArrayList<JRPrintFrame> headerRow = new ArrayList<JRPrintFrame>(this.lastColumnIndex - this.startColumnIndex);
                headerRows.add(headerRow);
                for (int j = 0; j < columnHeaderRows[i].length; ++j) {
                    JRFillCellContents contents = columnHeaderRows[i][j];
                    if (contents == null) continue;
                    headerRow.add(contents.fill());
                    contents.releaseWorkingClone();
                }
            }
            return headerRows;
        }

        private void releaseColumnHeaderCells(JRFillCellContents[][] columnHeaderRows) throws JRException {
            for (int i = 0; i < columnHeaderRows.length; ++i) {
                for (int j = 0; j < columnHeaderRows[i].length; ++j) {
                    JRFillCellContents contents = columnHeaderRows[i][j];
                    if (contents == null) continue;
                    contents.rewind();
                    contents.releaseWorkingClone();
                }
            }
        }

        protected int fillRows(int xOffset, int availableHeight) throws JRException {
            this.rowYs.clear();
            this.rowYs.add(0);
            this.rowIdx = 0;
            while (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.initPreparedRow();
                this.prepareRow(xOffset, availableHeight);
                if (this.willOverflow) break;
                this.fillRow();
                this.rowYs.add(this.rowYs.get(this.rowIdx) + this.preparedRowHeight);
                ++this.rowIdx;
            }
            if (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.releasePreparedRow();
                if (this.printRowHeaders) {
                    this.fillContinuingRowHeaders(xOffset, availableHeight);
                }
            }
            this.yOffset += this.rowYs.get(this.rowIdx).intValue();
            return this.rowIdx + this.startRowIndex;
        }

        private void initPreparedRow() {
            this.preparedRow.clear();
            this.preparedRowHeight = 0;
        }

        private void removeFilledRows(int rowsToRemove) {
            if (rowsToRemove > 0) {
                for (int i = 0; i < rowsToRemove; ++i) {
                    this.printRows.remove(this.printRows.size() - 1);
                    this.rowYs.remove(this.rowYs.size() - 1);
                }
                this.rowIdx -= rowsToRemove;
            }
        }

        private void releasePreparedRow() throws JRException {
            for (JRFillCellContents cell : this.preparedRow) {
                cell.rewind();
                cell.releaseWorkingClone();
            }
            this.preparedRow.clear();
        }

        private void fillRow() throws JRException {
            int rowY = this.rowYs.get(this.rowIdx);
            ArrayList<JRPrintElement> rowPrints = new ArrayList<JRPrintElement>(this.preparedRow.size());
            for (JRFillCellContents cell : this.preparedRow) {
                int spanHeight = 0;
                if (cell.getVerticalSpan() > 1) {
                    spanHeight = rowY - this.rowYs.get(this.rowIdx - cell.getVerticalSpan() + 1);
                }
                cell.stretchTo(this.preparedRowHeight + spanHeight);
                rowPrints.add(cell.fill());
                cell.releaseWorkingClone();
            }
            this.addPrintRow(rowPrints);
        }

        private void prepareRow(int xOffset, int availableHeight) throws JRException {
            for (int col = this.startColumnIndex; col < this.lastColumnIndex; ++col) {
                CrosstabCell data = JRFillCrosstab.this.cellData[this.rowIdx + this.startRowIndex][col];
                boolean overflow = this.prepareDataCell(data, col, availableHeight, xOffset);
                if (!overflow) continue;
                this.willOverflow = true;
                return;
            }
            this.resetVariables();
            if (this.printRowHeaders) {
                int j;
                for (j = 0; j < JRFillCrosstab.this.rowGroups.length; ++j) {
                    boolean overflow;
                    HeaderCell cell = JRFillCrosstab.this.rowHeadersData[j][this.rowIdx + this.startRowIndex];
                    int vSpan = 0;
                    if (cell == null) {
                        if (this.toCloseRowHeader(j)) {
                            cell = this.spanHeaders[j];
                            vSpan = cell.getLevelSpan();
                            if (this.spanHeadersStart[j] < this.startRowIndex) {
                                vSpan += this.spanHeadersStart[j] - this.startRowIndex;
                            }
                        }
                    } else {
                        if (cell.getLevelSpan() > 1) {
                            this.spanHeaders[j] = cell;
                            this.spanHeadersStart[j] = this.rowIdx + this.startRowIndex;
                            continue;
                        }
                        vSpan = 1;
                    }
                    if (cell == null || !(overflow = this.prepareRowHeader(j, cell, vSpan, availableHeight))) continue;
                    this.willOverflow = true;
                    return;
                }
                for (j = 0; j < JRFillCrosstab.this.rowGroups.length; ++j) {
                    if (JRFillCrosstab.this.rowHeadersData[j][this.rowIdx + this.startRowIndex] != null || !this.toCloseRowHeader(j)) continue;
                    this.spanHeaders[j] = null;
                }
                this.resetVariables();
            }
        }

        private boolean prepareDataCell(CrosstabCell data, int column, int availableHeight, int xOffset) throws JRException {
            boolean overflow;
            JRFillCellContents contents;
            int rowY = this.rowYs.get(this.rowIdx);
            JRFillCrosstabCell cell = JRFillCrosstab.this.crossCells[data.getRowTotalGroupIndex()][data.getColumnTotalGroupIndex()];
            JRFillCellContents jRFillCellContents = contents = cell == null ? null : cell.getFillContents();
            if (contents == null || contents.getWidth() <= 0 || contents.getHeight() <= 0) {
                return false;
            }
            boolean bl = overflow = availableHeight < rowY + contents.getHeight();
            if (!overflow) {
                boolean leftEmpty = this.startColumnIndex != 0 && !JRFillCrosstab.this.isRepeatRowHeaders();
                boolean topEmpty = this.startRowIndex != 0 && !JRFillCrosstab.this.isRepeatColumnHeaders();
                this.setCountVars(this.rowIdx + this.startRowIndex, column);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, data.getRowBucketValues());
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, data.getColumnBucketValues());
                this.setMeasureVariables(data);
                boolean firstOnRow = leftEmpty && column == this.startColumnIndex;
                contents = contents.getBoxContents(firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.LTR, firstOnRow && JRFillCrosstab.this.getRunDirectionValue() == RunDirectionEnum.RTL, topEmpty && this.rowIdx == 0);
                contents = contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - rowY);
                if (JRFillCrosstab.this.interactive) {
                    contents.setPrintProperty("net.sf.jasperreports.export.crosstab.columnIndex", Integer.toString(column));
                    contents.setPrintProperty("net.sf.jasperreports.export.html.class", "jrxtdatacell");
                }
                this.preparedRow.add(contents);
                overflow = contents.willOverflow();
                if (!overflow) {
                    contents.setX(this.columnXOffsets[column] - this.columnXOffsets[this.startColumnIndex] + xOffset);
                    contents.setY(rowY + this.yOffset);
                    int rowCellHeight = contents.getPrintHeight();
                    if (rowCellHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowCellHeight;
                    }
                }
            }
            return overflow;
        }

        private boolean prepareRowHeader(int rowGroup, HeaderCell cell, int vSpan, int availableHeight) throws JRException {
            boolean headerOverflow;
            JRFillCellContents contents;
            JRFillCrosstabRowGroup group = JRFillCrosstab.this.rowGroups[rowGroup];
            JRFillCellContents jRFillCellContents = contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            if (contents.getWidth() <= 0 || contents.getHeight() <= 0) {
                return false;
            }
            int spanHeight = 0;
            int headerY = this.rowYs.get(this.rowIdx - vSpan + 1);
            if (vSpan > 1) {
                spanHeight += this.rowYs.get(this.rowIdx) - headerY;
            }
            int rowHeight = spanHeight + this.preparedRowHeight;
            boolean stretchContents = group.getPositionValue() == CrosstabRowPositionEnum.STRETCH;
            int contentsHeight = stretchContents ? rowHeight : contents.getHeight();
            boolean bl = headerOverflow = availableHeight < headerY + contentsHeight || rowHeight < contents.getHeight();
            if (!headerOverflow) {
                this.setCountVars(this.rowIdx + this.startRowIndex - vSpan + 1, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, cell.getBucketValues());
                this.setGroupMeasureVariables(cell, true);
                if (stretchContents) {
                    contents = contents.getTransformedContents(contents.getWidth(), rowHeight, CrosstabColumnPositionEnum.LEFT, CrosstabRowPositionEnum.STRETCH);
                }
                contents = contents.getBoxContents(false, false, this.rowIdx + 1 == vSpan && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - headerY);
                if (JRFillCrosstab.this.interactive) {
                    contents.setPrintProperty("net.sf.jasperreports.export.crosstab.columnIndex", Integer.toString(rowGroup));
                    if (cell.getDepthSpan() == 1) {
                        contents.setPrintProperty("net.sf.jasperreports.export.html.class", "jrxtrowheader");
                    }
                }
                this.preparedRow.add(contents);
                headerOverflow = contents.willOverflow();
                if (!headerOverflow) {
                    contents.setX(this.rowHeadersXOffsets[rowGroup]);
                    contents.setY(headerY + this.yOffset);
                    contents.setVerticalSpan(vSpan);
                    contents.setHorizontalSpan(cell.getDepthSpan());
                    int rowCellHeight = contents.getPrintHeight() - spanHeight;
                    if (rowCellHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowCellHeight;
                    }
                }
            }
            if (headerOverflow) {
                this.removeFilledRows(vSpan - 1);
            }
            return headerOverflow;
        }

        protected boolean toCloseRowHeader(int rowGroup) {
            return rowGroup < JRFillCrosstab.this.rowGroups.length - 1 && this.spanHeaders[rowGroup] != null && this.spanHeaders[rowGroup].getLevelSpan() + this.spanHeadersStart[rowGroup] == this.rowIdx + this.startRowIndex + 1;
        }

        private void removeExceedingSpanHeaders() {
            for (int j = JRFillCrosstab.this.rowGroups.length - 2; j >= 0; --j) {
                if (this.spanHeaders[j] == null || this.spanHeadersStart[j] < this.rowIdx + this.startRowIndex) continue;
                this.spanHeaders[j] = null;
            }
        }

        private void setBackSpanHeaders() {
            for (int j = JRFillCrosstab.this.rowGroups.length - 2; j >= 0 && this.spanHeaders[j] == null; --j) {
                int spanIndex = this.getSpanIndex(this.rowIdx + this.startRowIndex, j, JRFillCrosstab.this.rowHeadersData);
                if (spanIndex < 0) continue;
                this.spanHeaders[j] = JRFillCrosstab.this.rowHeadersData[j][spanIndex];
                this.spanHeadersStart[j] = spanIndex;
            }
        }

        private void fillContinuingRowHeaders(int xOffset, int availableHeight) throws JRException {
            boolean done = false;
            block0: do {
                this.removeExceedingSpanHeaders();
                if (!this.rowBreakable[this.rowIdx + this.startRowIndex]) {
                    this.removeFilledRows(1);
                    this.setBackSpanHeaders();
                    continue;
                }
                this.initPreparedRow();
                for (int j = 0; j < JRFillCrosstab.this.rowGroups.length - 1; ++j) {
                    boolean headerOverflow;
                    if (this.spanHeaders[j] == null || !(headerOverflow = this.prepareContinuingRowHeader(j, availableHeight))) continue;
                    this.releasePreparedRow();
                    continue block0;
                }
                if (!this.preparedRow.isEmpty()) {
                    int lastRowHeight = this.rowYs.get(this.rowIdx) - this.rowYs.get(this.rowIdx - 1);
                    if (this.preparedRowHeight > lastRowHeight) {
                        this.refillLastRow(xOffset, availableHeight);
                    } else {
                        this.fillContinuingHeaders(lastRowHeight);
                    }
                }
                done = true;
            } while (!done && this.rowIdx > 0);
        }

        private void fillContinuingHeaders(int lastRowHeight) throws JRException {
            int nextToLastHeaderY = this.rowYs.get(this.rowIdx - 1);
            List<JRPrintElement> lastPrintRow = this.getLastPrintRow();
            for (int j = 0; j < this.preparedRow.size(); ++j) {
                JRFillCellContents contents = this.preparedRow.get(j);
                int headerY = this.rowYs.get(this.rowIdx - contents.getVerticalSpan());
                contents.stretchTo(nextToLastHeaderY - headerY + lastRowHeight);
                lastPrintRow.add(contents.fill());
                contents.releaseWorkingClone();
            }
        }

        private void refillLastRow(int xOffset, int availableHeight) throws JRException {
            this.removeFilledRows(1);
            this.setBackSpanHeaders();
            this.prepareRow(xOffset, availableHeight);
            this.fillRow();
            this.rowYs.add(this.rowYs.get(this.rowIdx) + this.preparedRowHeight);
            ++this.rowIdx;
        }

        private boolean prepareContinuingRowHeader(int rowGroup, int availableHeight) throws JRException {
            boolean headerOverflow;
            HeaderCell cell = this.spanHeaders[rowGroup];
            int vSpan = this.rowIdx + this.startRowIndex - this.spanHeadersStart[rowGroup];
            if (this.spanHeadersStart[rowGroup] < this.startRowIndex) {
                vSpan += this.spanHeadersStart[rowGroup] - this.startRowIndex;
            }
            int headerY = this.rowYs.get(this.rowIdx - vSpan);
            int lastHeaderY = this.rowYs.get(this.rowIdx);
            int headerHeight = lastHeaderY - headerY;
            int nextToLastHeaderY = this.rowYs.get(this.rowIdx - 1);
            int stretchHeight = nextToLastHeaderY - headerY;
            JRFillCrosstabRowGroup group = JRFillCrosstab.this.rowGroups[rowGroup];
            JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            boolean stretchContents = group.getPositionValue() == CrosstabRowPositionEnum.STRETCH;
            int contentsHeight = stretchContents ? headerHeight : contents.getHeight();
            boolean bl = headerOverflow = availableHeight < headerY + contentsHeight || headerHeight < contents.getHeight();
            if (!headerOverflow) {
                this.setCountVars(this.rowIdx + this.startRowIndex - vSpan, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, cell.getBucketValues());
                this.setGroupMeasureVariables(cell, true);
                if (stretchContents) {
                    contents = contents.getTransformedContents(contents.getWidth(), headerHeight, CrosstabColumnPositionEnum.LEFT, CrosstabRowPositionEnum.STRETCH);
                }
                contents = contents.getBoxContents(false, false, this.rowIdx == vSpan && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(availableHeight - headerY);
                if (JRFillCrosstab.this.interactive) {
                    contents.setPrintProperty("net.sf.jasperreports.export.crosstab.columnIndex", Integer.toString(rowGroup));
                    if (cell.getDepthSpan() == 1) {
                        contents.setPrintProperty("net.sf.jasperreports.export.html.class", "jrxtrowheader");
                    }
                }
                this.preparedRow.add(contents);
                headerOverflow = contents.willOverflow();
                if (!headerOverflow) {
                    contents.setX(this.rowHeadersXOffsets[rowGroup]);
                    contents.setY(headerY + this.yOffset);
                    contents.setVerticalSpan(vSpan);
                    contents.setHorizontalSpan(cell.getDepthSpan());
                    int rowHeight = contents.getPrintHeight() - stretchHeight;
                    if (rowHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowHeight;
                    }
                }
            }
            if (headerOverflow) {
                this.removeFilledRows(vSpan);
            }
            return headerOverflow;
        }

        protected void addPrintRow(List<JRPrintElement> printRow) {
            this.printRows.add(printRow);
        }

        protected List<JRPrintElement> getLastPrintRow() {
            return this.printRows.get(this.printRows.size() - 1);
        }

        protected void setGroupVariables(JRFillCrosstabGroup[] groups, BucketDefinition.Bucket[] bucketValues) {
            for (int i = 0; i < groups.length; ++i) {
                Object value = null;
                if (bucketValues[i] != null && !bucketValues[i].isTotal()) {
                    value = bucketValues[i].getValue();
                }
                groups[i].getFillVariable().setValue(value);
            }
        }

        protected void setGroupMeasureVariables(HeaderCell cell, boolean rowGroup) {
            MeasureDefinition.MeasureValue[][] totals = cell.getTotals();
            for (int m = 0; m < JRFillCrosstab.this.measures.length; ++m) {
                for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                    for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                        MeasureDefinition.MeasureValue[] vals;
                        MeasureDefinition.MeasureValue[] measureValueArray = vals = rowGroup ? totals[row] : totals[col];
                        if (row == JRFillCrosstab.this.rowGroups.length && col == JRFillCrosstab.this.columnGroups.length) {
                            Object value = this.measureValue(vals, m);
                            JRFillCrosstab.this.measures[m].getFillVariable().setValue(value);
                            continue;
                        }
                        if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                        JRFillVariable totalVar = JRFillCrosstab.this.totalVariables[row][col][m];
                        Object value = this.measureValue(vals, m);
                        totalVar.setValue(value);
                    }
                }
            }
        }

        protected void setMeasureVariables(CrosstabCell cell) {
            MeasureDefinition.MeasureValue[] values = cell.getMesureValues();
            for (int i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                Object value = this.measureValue(values, i);
                JRFillCrosstab.this.measures[i].getFillVariable().setValue(value);
            }
            MeasureDefinition.MeasureValue[][][] totals = cell.getTotals();
            for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                    MeasureDefinition.MeasureValue[] vals = totals[row][col];
                    if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                    for (int m = 0; m < JRFillCrosstab.this.measures.length; ++m) {
                        JRFillVariable totalVar = JRFillCrosstab.this.totalVariables[row][col][m];
                        Object value = this.measureValue(vals, m);
                        totalVar.setValue(value);
                    }
                }
            }
        }

        protected Object measureValue(MeasureDefinition.MeasureValue[] values, int measureIdx) {
            if (values == null) {
                return null;
            }
            Object value = JRFillCrosstab.this.measures[measureIdx].getPercentageType() == CrosstabPercentageEnum.GRAND_TOTAL ? (values[measureIdx].isInitialized() ? values[measureIdx].getValue() : JRFillCrosstab.this.measures[measureIdx].getPercentageCalculator().calculatePercentage(values[measureIdx], JRFillCrosstab.this.grandTotals[measureIdx])) : values[measureIdx].getValue();
            return value;
        }

        protected void resetVariables() {
            int i;
            for (i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                JRFillCrosstab.this.rowGroups[i].getFillVariable().setValue(null);
            }
            for (i = 0; i < JRFillCrosstab.this.columnGroups.length; ++i) {
                JRFillCrosstab.this.columnGroups[i].getFillVariable().setValue(null);
            }
            for (i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                JRFillCrosstab.this.measures[i].getFillVariable().setValue(null);
            }
            for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                    if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                    for (int i2 = 0; i2 < JRFillCrosstab.this.measures.length; ++i2) {
                        JRFillCrosstab.this.totalVariables[row][col][i2].setValue(null);
                    }
                }
            }
        }
    }

    public class JRFillCrosstabDataset
    extends JRFillElementDataset
    implements JRCrosstabDataset {
        private Object[] bucketValues;
        private Object[] measureValues;

        public JRFillCrosstabDataset(JRCrosstabDataset dataset, JRFillObjectFactory factory) {
            super(dataset, factory);
            this.bucketValues = new Object[JRFillCrosstab.this.rowGroups.length + JRFillCrosstab.this.columnGroups.length];
            this.measureValues = new Object[JRFillCrosstab.this.measures.length];
        }

        @Override
        protected void customInitialize() {
            JRFillCrosstab.this.initBucketingService();
        }

        @Override
        protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
            int i;
            for (i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                this.bucketValues[i] = calculator.evaluate(JRFillCrosstab.this.rowGroups[i].getBucket().getExpression());
            }
            for (i = 0; i < JRFillCrosstab.this.columnGroups.length; ++i) {
                this.bucketValues[i + JRFillCrosstab.this.rowGroups.length] = calculator.evaluate(JRFillCrosstab.this.columnGroups[i].getBucket().getExpression());
            }
            for (i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                this.measureValues[i] = calculator.evaluate(JRFillCrosstab.this.measures[i].getValueExpression());
            }
        }

        @Override
        protected void customIncrement() {
            try {
                JRFillCrosstab.this.bucketingService.addData(this.bucketValues, this.measureValues);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Error incrementing crosstab dataset", e);
            }
        }

        @Override
        public void collectExpressions(JRExpressionCollector collector) {
        }

        @Override
        public boolean isDataPreSorted() {
            return ((JRCrosstabDataset)this.parent).isDataPreSorted();
        }
    }
}

