<?php
session_start();
include "./conexion.php";

function regresaMes($mes) {
    $meses = [
        1 => "Enero", 2 => "Febrero", 3 => "Marzo", 4 => "Abril",
        5 => "Mayo", 6 => "Junio", 7 => "Julio", 8 => "Agosto",
        9 => "Septiembre", 10 => "Octubre", 11 => "Noviembre", 12 => "Diciembre"
    ];
    return $meses[$mes] ?? null;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Taller</title> <link rel="icon" href="./icons/taller.png" type="image/png">
    <link rel="stylesheet" href="./sidemenu.css">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

    <style>
        .custom-alert {
            position: fixed;
            top: 20%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: white;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            z-index: 1000;
            display: none;
            text-align: center;
            border-radius: 5px;
        }

        .custom-alert button {
            margin-top: 10px;
            padding: 5px 10px;
            cursor: pointer;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }

        .container2 {
            display: flex;
            align-items: left; /* Alinea verticalmente al centro */
            margin-left: 200px;
            margin-right: var(--margen-derecho);
            margin-top: var(--margen-derecho);
        }

        label {
            margin-right: 5px; /* Espacio entre la etiqueta y el select */
            font-weight: bold;
            color: #333;
        }

        select {
            width: 200px; /* Asegúrate de que todos los selects tengan la misma anchura */
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 12px;
            margin-right: 10px; /* Espacio entre los selects */
        }

        input {
            width: 200px; /* Asegúrate de que todos los selects tengan la misma anchura */
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 12px;
            margin-right: 10px; /* Espacio entre los selects */
        }

        button {
            margin-left: 10px; /* Espacio entre los selects y el botón */
            padding: 10px 15px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 12px;
            cursor: pointer;
        }

        button:hover {
            background-color: #218838;
        }

        .tabla-asistencia {
            font-family: Arial, sans-serif;
            font-size:12pt;
            border-collapse: collapse;
            width: 100%;
            margin-top: 10px;
        }

        .tabla-asistencia th, .tabla-asistencia td {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
            font-size:8pt;
        }

        .tabla-asistencia th {
            background-color: #6fb6fc;
            color: white;
            text-transform: uppercase;
        }

        .tabla-asistencia td {
            background-color: #white;
        }

        .tabla-asistencia .descanso {
            text-align: center;    
            background-color: #c1c2c3;
            
        }

        .tabla-asistencia .sin-checada {
            background-color: #fa5534;
            color:white;
            text-align: center;
        }

        .tabla-asistencia .checada-ok {
            background-color: #95faaf;
            text-align: center;
        }
        .tabla-asistencia .checada-warning {
            background-color: #fa9112;
            text-align: center;
            font-weight: bold;
            color:white;
        }
        .paginacion {
            display: flex;
            justify-content: right;
            align-items: center;
            margin-top: 5px;
        }

        .paginacion a, .paginacion strong {
            margin: 0 5px;
            padding: 8px 12px;
            text-decoration: none;
            border: 1px solid #ccc;
            border-radius: 4px;
            color: white;
        }

        .paginacion a:hover {
            background-color: #79e6fc;
        }

        .btn-paginacion {
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            padding: 8px 12px;
            text-decoration: none;
            border-radius: 4px;
        }

        .btn-paginacion:hover {
            background-color: #79e6fc;
        }

        .pagina-actual {
            background-color: #199be5;
            color: white;
            padding: 8px 12px;
            border-radius: 4px;
        }
    </style>

</head>
<body  >
    

    <!--<div id="sidemenu" class="menu-collapsed">-->
    <div id="sidemenu" class="menu-expanded">
        <!-- Header -->
        <div id="header">
            <div id="title"><span></span> </div>
            <div id="menu-btn">
                <div class="btn-hamburger"></div>
                <div class="btn-hamburger"></div>
                <div class="btn-hamburger"></div>
            </div>
        </div>
        <!--Profile-->
        <div id="profile">
            <div id="photo"><img src="img/user.png" alt=""></div>
            
        </div>
        <!--Items-->
        <div id="menu-items">
            <?php include './includes/navs3.php'?>
        </div>
    </div>
    <!--<div id="main-container">-->
    
<!-- -->
<!--<div class="container-fluid">-->
<div id="datos" style="width:100%;text-align:left;">
<div id="customAlert" class="custom-alert">
    <p id="alertText"></p>
    <button onclick="closeAlert()">Aceptar</button>
</div>

<div id="carga" class="custom-alert">
    <p><img src="./img/loading2.gif" alt="Cargando..."></p>
</div>

<div class="container2" >
<?php 
$registros_por_pagina = 20; // Número de registros por página
$pagina_actual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$inicio_registro = ($pagina_actual - 1) * $registros_por_pagina;

$consulta = "SELECT * FROM datos_periodos WHERE anio > 0 ORDER BY sem DESC, anio DESC";
// Contar el total de registros para paginación
$total_resultados = mysqli_query($connection, "SELECT COUNT(*) AS total FROM datos_periodos WHERE anio > 0");
$total_registros = mysqli_fetch_assoc($total_resultados)['total'];

// Modificar la consulta para obtener solo los registros necesarios
$consulta .= " LIMIT $inicio_registro, $registros_por_pagina";

    $sqlperiodos = mysqli_query($connection,$consulta);
    $resultx=mysqli_num_rows($sqlperiodos);
    if($resultx>0){
        echo '
        <table class="tabla-asistencia">
        <tr><td colspan="5" style="text-align:right"><button onclick="$(\'#cargarPrenominaModal\').modal(\'show\')">Cargar Prenómina</button></td></tr>
                    <tr>
                        <th colspan="5" style="text-align:center">Periodos Ingresados</th>
                        </tr>
                    <tr>
                    <th style="width:40px"></th>    
                    <th style="width:60px">Año</th>
                        <th style="width:60px">mes</th>
                        <th style="width:60px">Semana</th>
                        <th></th>
                    </tr>';
                    $i = 1 + $inicio_registro;
        while($data=mysqli_fetch_array($sqlperiodos)){
            echo    '<tr>
                        <td>'.$i++.'</td>
                        <td>'.$data['anio'].'</td>
                        <td>'.regresaMes($data['mes']).'</td>
                        <td>'.$data['sem'].'</td>
                        <td>Prenomina #'.$data['sem'].' mes de '.regresaMes($data['mes']).' de '.$data['anio'].'</td>
                    </tr>';
        }
        echo '</table>
        </div>';
    }
    else{
        echo '
        <table class="tabla-asistencia">
        <tr><td colspan="5" style="text-align:right"><button onclick="$(\'#cargarPrenominaModal\').modal(\'show\')">Cargar Prenómina</button></td></tr>
                    <tr>
                        <th colspan="5" style="text-align:center">Periodos Ingresados</th>
                        </tr>
                    <tr>
                    <th style="width:40px"></th>    
                    <th style="width:60px">Año</th>
                        <th style="width:60px">mes</th>
                        <th style="width:60px">Semana</th>
                        <th></th>
                    </tr>';
                    $i = 1 + $inicio_registro;
        while($data=mysqli_fetch_array($sqlperiodos)){
            echo    '<tr>
                        <td>'.$i++.'</td>
                        <td>'.$data['anio'].'</td>
                        <td>'.regresaMes($data['mes']).'</td>
                        <td>'.$data['sem'].'</td>
                        <td>Prenomina #'.$data['sem'].' mes de '.regresaMes($data['mes']).' de '.$data['anio'].'</td>
                    </tr>';
        }
        echo '</table>
        </div>';
        echo 'No hay datos que mostrar.';
    }
    $total_paginas = ceil($total_registros / $registros_por_pagina);
    
echo '<div class="paginacion">';

// Botón de "Inicio"
if ($pagina_actual > 1) {
    echo '<a href="?pagina=1" class="btn-paginacion"><i class="fa-solid fa-backward-fast"></i></a>';
}

// Enlaces a las páginas anteriores
$rango_paginas = 2;
$inicio_rango = max(1, $pagina_actual - $rango_paginas);
$fin_rango = min($total_paginas, $pagina_actual + $rango_paginas);

for ($i = $inicio_rango; $i <= $fin_rango; $i++) {
    if ($i == $pagina_actual) {
        echo '<strong class="pagina-actual">' . $i . '</strong>';
    } else {
        echo '<a href="?pagina=' . $i . '" class="btn-paginacion">' . $i . '</a>';
    }
}

// Botón de "Final"
if ($pagina_actual < $total_paginas) {
    echo '<a href="?pagina=' . $total_paginas . '" class="btn-paginacion"><i class="fa-solid fa-forward-fast"></i></a>';
}

echo '</div>';
        
?>

<!-- Modal -->
<div class="modal fade" id="cargarPrenominaModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document" style="max-width: 90%;">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="uploadModalLabel">Subir archivo Excel</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form id="uploadForm" enctype="multipart/form-data">
                            <div class="form-group">
                                <label for="file">Selecciona archivo (.xls, .xlsx)</label>
                                <input type="file" class="form-control-file" name="file" id="file" accept=".xls,.xlsx" required>
                            </div>
                            <p class="statusMsg1"></p>
                        </form>
                        <div id="datosx"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-primary" form="uploadForm">Subir archivo</button>
                    </div>
                </div>
            </div>
        </div>

        <div id="datos"></div>


    

<!-- 
    </div>-->

    <!-- Pie de página -->
    <!--<footer>
        <?php include "includes/footer.php"; ?>
    </footer>-->

    <!--<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        const btn = document.querySelector('#menu-btn');
        const menu = document.querySelector('#sidemenu');

        /*btn.addEventListener('click', e => {
            menu.classList.toggle("menu-expanded");
            menu.classList.toggle("menu-collapsed");

            document.querySelector('body').classList.toggle('body-expanded')
        });*/
    </script>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>




<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

        <script>
            $(document).ready(function(){
                $('#uploadForm').on('submit', function(e){
                    e.preventDefault(); // Evitar el comportamiento normal del formulario
                    var formData = new FormData(this);
                    $('#datosx').html(''); // Limpiar contenido previo

                    // Mensaje de carga
                    $('.statusMsg1').html('<p>Cargando información, por favor espera...</p>');

                    $.ajax({
                        type: 'POST',
                        url: 'procesarPrenomina.php',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        success: function(response){
                            $('.statusMsg1').html(''); // Limpiar el mensaje de estado
                            $('#datosx').html(response); // Mostrar la respuesta del servidor
                            //$('#cargarPrenominaModal').modal('hide'); // Ocultar el modal después de la subida
                        },
                        error: function(xhr, status, error){
                            console.log(xhr.responseText); // Para obtener más detalles en la consola
                            alert('Error: ' + error + '\nEstado: ' + status);
                        }
                    });
                });
            });
        </script>
</body>
</html>
