<?php
session_start();
include '../conexion.php';
$subtotal=null;    
mysqli_set_charset($connection, "utf8");
//header("Content-Type: text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Taller</title> <link rel="icon" href="./icons/taller.png" type="image/png">
    <link rel="stylesheet" href="./sidemenu.css">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="./sidemenu.css">
    <!-- jQuery library -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>

<!-- Latest minified bootstrap js -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<style>
.modal-dialog {
    display: flex;
    align-items: center;
    justify-content: center;
    max-width: 80%;
    margin: 0 auto; /* Centra horizontalmente */
}

.modal-content {
    height: 80%; /* Ajusta al 80% de la altura de la pantalla */
    overflow-y: auto; /* Permite el desplazamiento si el contenido es muy grande */
}
</style>

</head>
<body  >
    <div class="wrapper">
        <main>    
            <!-- Encabezado -->
            <header>
                <!--<h1>Taller</h1>-->
                <?php include "includes/header2.php"; ?>
            </header>

            <!--<div id="sidemenu" class="menu-collapsed">-->
            <div id="sidemenu" class="menu-expanded">
                <!-- Header -->
                <div id="header">
                    <div id="title"><span></span> </div>
                    <div id="menu-btn">
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                    </div>
                </div>
                <!--Profile-->
                <!--<div id="profile">
                    <div id="photo"><img src="img/user.png" alt=""></div>
                    <div id="name"><span><?php echo $_SESSION['nombre'];?></span></div>
                    <div id="name"><span><?php echo $_SESSION['iduser']." [ ".$_SESSION['user']." ] ";?></span></div>
                    <div id="name"><span><?php echo "Sucursal: ".$_SESSION['suc'];?></span></div>
                    <div id="name"><span> <?php echo "Rol: ".$_SESSION['rol'];?></span></div>
                </div>-->
                <!--Items-->
                <div id="menu-items">
                    <?php include './includes/navs3.php'?>
                </div>
            </div>

            <div style="height:calc(100%); width:90%; padding-right:15px; padding-left:200px; margin-right:60px; margin-left:60px;margin-top:20px;">

            
            <div style="width:100%;">
                <table border='0' style='width:100%;'>
                    <tr>
                    <td style='text-align:right;'><button class="btn btn-primary btn-sm" onclick="actualizarPagina()"><i class="fa-solid fa-arrows-rotate"></i></button>
                    <button class="btn btn-success btn-sm" data-backdrop="static" data-keyboard="false" data-toggle="modal" data-target="#modalAlta"><i class="fa-solid fa-circle-plus"></i></button>
                    <button style="margin-right:15px;" class="btn btn-info btn-sm" data-backdrop="static" data-keyboard="false" data-toggle="modal" data-target="#modalSubir"><i class="fa-solid fa-upload"></i></button>
                    <input ID="busqueda" type="text" autocomplete="off" style="width:200px;"placeholder="Captura dato a buscar" onkeydown="if (event.key === 'Enter') buscar()">
                        <button id="btnBusqueda" class="btn btn-primary btn-sm" type="button" onclick="buscar()"><i class="fa-solid fa-magnifying-glass"></i></button>
                    </td>
                </tr>
                </table>
                <div class="table-container" style="width:100%;heigth:100%">
                    <table border='0' style='width:100%;font-size:8pt;'>
                        <thead>
                            <tr>
                                <th style="width:5%;">id</th>
                                <th style="width:10%;">Ubicacion</th>
                                <th style="width:15%;">Supervisor</th>
                                <th style="width:15;">Lugar de Trabajo</th>
                                <th style="width:10%;">Num Empl.</th>
                                <th style="width:25%;">Nombre</th>
                                <!--<th style='text-align:center;'>Monto</th>-->
                                <th style="width:20%;">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        $busq = filter_input(INPUT_GET, 'busqueda', FILTER_SANITIZE_STRING) ?: '';
                        $pagina = filter_input(INPUT_GET, 'pagina', FILTER_VALIDATE_INT) ?: 1;

                        $por_pagina = 15;
                        $desde = ($pagina - 1) * $por_pagina;

                        // Total registros
                        $query_total = "SELECT COUNT(*) as total_registros FROM uni_empleados WHERE supervisor = ? OR lugar_trabajo LIKE ? OR nombre LIKE ? OR num_emp LIKE ? OR ubicacion LIKE ?";
                        $stmt = $connection->prepare($query_total);
                        $likeBusq = "%{$busq}%";
                        $stmt->bind_param("sssss", $busq, $likeBusq, $likeBusq, $likeBusq, $likeBusq);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        $total_registros = $result->fetch_assoc()['total_registros'];

                        $total_paginas = ceil($total_registros / $por_pagina);

                        // Consulta principal
                        $query = "SELECT * FROM uni_empleados WHERE supervisor = ? OR lugar_trabajo LIKE ? OR nombre LIKE ? OR num_emp LIKE ? OR ubicacion LIKE ? ORDER BY num_emp ASC LIMIT ?, ?";
                        $stmt = $connection->prepare($query);
                        $stmt->bind_param("sssssii", $busq, $likeBusq, $likeBusq, $likeBusq, $likeBusq, $desde, $por_pagina);
                        $stmt->execute();
                        $result = $stmt->get_result();

                        if ($result->num_rows > 0) {
                            while ($data = $result->fetch_assoc()) {
                                echo "<tr>
                                        <td style='text-align:left;padding-left:20px'>{$data['idempleado']}</td>
                                        <td style='text-align:left;padding-left:20px'>{$data['ubicacion']}</td>
                                        <td style='text-align:left;padding-left:20px'>{$data['supervisor']}</td>
                                        <td style='text-align:left;padding-left:20px'>{$data['lugar_trabajo']}</td>
                                        <td style='text-align:left;padding-left:20px'>{$data['num_emp']}</td>
                                        <td style='text-align:left;padding-left:20px'>" . htmlspecialchars($data['nombre'], ENT_QUOTES, 'UTF-8') . "</td>
                                        <td>
                                            
                                            <button class='btn btn-primary btn-sm' id='modificar' data-backdrop='static' data-keyboard='false' data-id='{$data['idempleado']}' data-toggle='modal' data-target='#modalEmpleado'><i class='fa-solid fa-file-pen'></i></button>
                                                <!--<button class='btn btn-danger btn-sm' id='cancelar' data-backdrop='static' data-keyboard='false' data-id='{$data['idempleado']}' data-toggle='modal' data-target='#deleteModal'><i class='fa-solid fa-ban'></i></button>-->
                                        </td>
                                    </tr>";
                            }
                        }
                        ?>

                            <!-- Agrega más filas según sea necesario -->
                        </tbody>
                    </table>
                </div>
                <div class="paginador">
                    <ul><?php
                        $numeroInicio=1;
                        if($pagina!=1){
                        //$numeroInicio=1;
                        
                    ?>
                        
                        <li><a href="?pagina=<?php echo $numeroInicio?>&busqueda=<?php echo $busq?>"><i class="fa-solid fa-backward-fast"></i></a></li>
                        <!--<li><a href="?pagina=<?php /*echo $pagina-1*/?>"><<</a></li>-->
                        <?php 
                        }
                            if(($pagina-3)>1){
                                $numeroInicio=$pagina-3;
                            }
                            $numeroFin=$numeroInicio+4;
                            
                            if($numeroFin>$total_paginas){
                                $numeroFin=$total_paginas;
                            }
                            
                            for($i=$numeroInicio;$i<=$numeroFin;$i++){
                                if($i==$pagina){
                                    echo '<li class="pageSelected">'.$i.'</li>';
                                } else{
                                echo '<li><a href="?pagina='.$i.'&busqueda='.$busq.'">'.$i.'</a></li>';
                                }
                            }
                            if($pagina!=$total_paginas){
                                echo '<li><a href="?pagina='.$total_paginas.'&busqueda='.$busq.'"><i class="fa-solid fa-forward-fast"></i></a></li>';
                            }
                        ?>
                                        
                        
                    </ul>
                </div>
            </div>
            

            </div>


            




        </main>
            <!-- Pie de página -->
            <footer>
                <?php include "includes/footer.php"; ?>
            </footer>
    </div>

<!-- Agregar el modal de carga -->
<div class="modal" id="cargandoModalx" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <p style="text-align:center;"><img src="./img/loading2.gif" alt="Cargando"><img> Cargando información, favor de esperar..</p>
      </div>
    </div>
  </div>
</div>



		<!-- Modal -->
<div class="modal fade" id="modalSubir" role="dialog">
    <div class="modal-dialog" style="width:80%">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <button style="width:"type="button" class="close" data-dismiss="modal" onclick="reloadPage()">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Carga de archivo</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body">
            <p class="statusMsg"></p>
    <div>
        <table>
        <form id="uploadForm" enctype="multipart/form-data">
            <tr>
                <td style="width:200px"><input type="file" name="file" id="file" accept=".xls,.xlsx"></td>
                <td><button type="submit" class="btn btn-primary" name="submit">Subir archivo</button></td>
            </tr>
            <tr>
                <td colspan="2" style="text-align:center;"><p class="statusMsg1"></p> </td>
            </tr>
        
        <!--<button type="submit" name="submit">Upload File</button>-->
        
    </form>
                </table>
</div>
<div id="datosx">
    <div>

<!-- Modal Footer -->
<div class="modal-footer">
    <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal">Cerrar</button>
    <!--<button type="button" class="btn btn-primary" onclick="enviarFormularios()">Enviar</button>-->

</div>
    </div>

    


</div>
</div>
</div>
</div>
</div>


<!-- Modal view-->
<div class="modal fade" id="modalEmpleado" role="dialog" >
    <div class="modal-dialog" >
        <div class="modal-content" style="width:600px;">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Datos Empleado</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body" >
                <p class="statusMsg"></p>    
                <form role="form">
                <table >
				<tr>
				<td  style="text-align:left; width:20%">
				<div class="form-group">
                        <input style="font-size: 12px;" type="hidden" class="form-control" id="id"/>
                        <input style="font-size: 12px;" type="hidden" class="form-control" id="tipoMov" value="2"/>
                        <label style="font-size: 12px;" for="numEmp">Num Empleado</label>
						<input style="font-size: 12px;" type="int" autocomplete="off" class="form-control" id="numEmp" />
                    </div>
				</td>
                <td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="nombre">Nombre:</label>
                        <input style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="nombre" />
                    </div>
				</td>
                        </tr>
                        </table >
                <table >
				<tr>
                <td  style="text-align:left;width:25%">
				<div class="form-group">
                        <label style="font-size: 12px;" for="ubicacion">Ubicación:</label>
                        <input disabled style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="ubicacion" />
                    </div>
				</td>
                <td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="supervisor">Supervisor:</label>
                        <input disabled style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="supervisor" />
                    </div>
				</td>
                </tr>
                        </table >
                <table >
				<tr>
                <td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="lugar">Lugar de trabajo:</label>
                        <input disabled style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="lugar" />
                    </div>
				</td>
                        </tr>
                        </table >

                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <button  disabled type="button" class="btn btn-primary submitBtn" onclick="guardarEmpleado()">GUARDAR</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal view-->
<div class="modal fade" id="modalAlta" role="dialog" >
    <div class="modal-dialog" >
        <div class="modal-content" style="width:600px;">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Alta Empleado</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body" >
                <p class="statusMsg"></p>    
                <form role="form">
                <table >
				<tr>
				<td  style="text-align:left; width:20%">
				<div class="form-group">
                        <input style="font-size: 12px;" type="hidden" class="form-control" id="id"/>
                        <input style="font-size: 12px;" type="hidden" class="form-control" id="tipoMovx" value="1"/>
                        <label style="font-size: 12px;" for="numEmp">Num Empleado</label>
						<input style="font-size: 12px;" type="int" autocomplete="off" class="form-control" id="numEmpx" value='99999' disabled/>
                    </div>
				</td>
                <td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="nombrex">Nombre:</label>
                        <input style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="nombrex" />
                    </div>
				</td>
                        </tr>
                        </table >
                <table >
				<tr>
                <td  style="text-align:left;width:25%">
				<div class="form-group">
                        <label style="font-size: 12px;" for="ubicacionx">Ubicación:</label>
                        <!--<input disabled style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="ubicacion" />-->
                        <select onchange="cargarSupervisores()" style="width:100%" class="form-control" id="ubicacionx">
                        <option value="0">--Selecciona--</option>    
                            <option value="TIJUANA">TIJUANA</option>
                            <option value="ENSENADA">ENSENADA</option>
                            <option value="MEXICALI">MEXICALI</option>
                        </select>
                    </div>
				</td>
                <td  style="text-align:left;">
                    <!--<div id="supervisores">-->
				<div class="form-group">
                        <label style="font-size: 12px;" for="supervisor">Supervisor:</label>
                        <!--<input disabled style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="supervisorx" />-->
                        <select onchange="cargarLugares()" style="width:100%" class="form-control" id="supervisorx">
                        <option selected value="0">Selecciona un supervisor</option>
                        </select>
                    </div>
				</td>
                </tr>
                        </table >
                <table >
				<tr>
                <td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="lugarx">Lugar de trabajo:</label>
                        <!--<input disabled style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="lugarx" />-->
                        <select style="width:100%" class="form-control" id="lugarx">
                        <option selected value="0">Selecciona un lugar</option>
                        </select>
                    </div> 
				</td>
                        </tr>
                        </table >

                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <button type="button" class="btn btn-primary submitBtnx" onclick="guardarEmpleadox()">GUARDAR</button>
            </div>
        </div>
    </div>
</div>


    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        const btn = document.querySelector('#menu-btn');
        const menu = document.querySelector('#sidemenu');

        btn.addEventListener('click', e => {
            menu.classList.toggle("menu-expanded");
            menu.classList.toggle("menu-collapsed");

            document.querySelector('body').classList.toggle('body-expanded')
        });
    

        $(document).on('click', '[data-target="#modalAlta"]', function () {
            //cargarSupervisores();
        });

$(document).on('click', '[data-target="#modalEmpleado"]', function () {
    // Capturamos el valor del atributo `data-id`
    var idUsuario = $(this).data('id');
    
    // Realizamos la solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'obtener_empleado.php', // Cambia esto por el nombre de tu archivo PHP 
        data: { idUsuario: idUsuario },
        success: function(response) {
            alert(response);
            try {
                var data = JSON.parse(response); // Parsea la respuesta JSON
                $('#modalEmpleado').find('#id').val(data.id);
                $('#modalEmpleado').find('#nombre').val(data.nombre);
                $('#modalEmpleado').find('#numEmp').val(data.num);
                $('#modalEmpleado').find('#supervisor').val(data.supervisor);
                $('#modalEmpleado').find('#lugar').val(data.lugar);
                $('#modalEmpleado').find('#ubicacion').val(data.ubicacion);
                // Abrimos el modal
                //$('.submitBtn').prop('disabled', true);
                $('.submitBtn').prop('disabled', false);
            } catch (e) {
                console.error('Error procesando los datos del servidor: ', e);
                alert('Error al cargar los datos. Intente nuevamente.');
            }
        },
        error: function() {
            alert('Ocurrió un error al obtener los datos. Por favor, inténtelo más tarde.');
        }
    });
});


function buscar() {
    // Obtiene el valor del input con ID "busqueda"
    const busqueda = document.getElementById("busqueda").value;
    
    // Define la página que deseas agregar (puedes cambiar este valor)
    //const pagina = <?php echo isset($_GET['pagina']) ? json_encode($_GET['pagina']) : '1'; ?>;
    const pagina = '1';
    // Obtén la URL actual
    let url = new URL(window.location.href);

    // Agrega o actualiza los parámetros "buscar" y "pagina"
    url.searchParams.set("busqueda", busqueda);
    url.searchParams.set("pagina", pagina);

    // Redirige a la URL modificada
    window.location.href = url.toString();
}

function guardarEmpleado() {
        var id = $('#id').val();
        var nombre = $('#nombre').val();
        var num = $('#numEmp').val();
        var tipo = $('#tipoMov').val();
        


            if (!nombre) {
                $('.statusMsg').html('<span style="color:red;">El nombre es un campo obligatorio.</span>');
                return;
            }else if (!num) {
                $('.statusMsg').html('<span style="color:red;">El numero de empleado es un campo obligatorio.</span>');
                return;
            }else{
                // Preparar datos para enviar
                    var datos = {
                        id : id,
                        nombre : nombre,
                        num : num,
                        tipo : tipo
                    };


                
                // Enviar solicitud AJAX
                $.ajax({
                    type: 'POST',
                    url: 'guardar_empleado.php', // Cambiar por tu ruta PHP
                    data: datos,
                    beforeSend: function() {
                        // Deshabilitar el botón mientras se procesa la solicitud
                        $('.submitBtn').prop('disabled', true);
                        $('.statusMsg').html('<span style="color:blue;">Procesando...</span>');
                    },
                    success: function (response) {
                        try {
                            var data = JSON.parse(response);

                            if (data.dato) {
                                // Éxito: Mostrar mensaje en verde y mantener deshabilitado
                                $('.statusMsg').html('<span style="color:green;">' + data.message + '.</span>');
                                $('.tipoMov').val(0); // Resetear el valor del input
                                $('#nombre').prop('disabled', true);
                                $('#ubicacion').prop('disabled', true);
                                $('#supervisor').prop('disabled', true);
                                $('#lugar').prop('disabled', true);
                                $('#numEmp').prop('disabled', true);
                            } else {
                                // Error del servidor: Mostrar mensaje en rojo y habilitar de nuevo
                                $('.statusMsg').html('<span style="color:red;">' + data.message + '</span>');
                                $('.submitBtn').prop('disabled', false);
                            }
                        } catch (e) {
                            // Error al procesar la respuesta JSON
                            $('.statusMsg').html('<span style="color:red;">Error al procesar la respuesta del servidor: ' + e.message + '</span>');
                            $('.submitBtn').prop('disabled', false);
                        }
                    },
                    error: function (xhr, status, error) {
                        // Error en la solicitud AJAX
                        $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + status + ' - ' + error + '</span>');
                        $('.submitBtn').prop('disabled', false);
                    },
                    complete: function () {
                        // No rehabilitar el botón aquí, ya se controla por la lógica de éxito o error
                    }
                });

            }

}

function guardarEmpleadox() {
        var id = $('#id').val();
        var nombre = $('#nombrex').val();
        var num = $('#numEmpx').val();
        var ubicacion = $('#ubicacionx').val();
        var supervisor = $('#supervisorx').val();
        var lugar = $('#lugarx').val();
        var tipo = $('#tipoMovx').val();
        
        //alert(nombre+' | '+num+' | '+ubicacion+' | '+supervisor+' | '+lugar);

            if (!nombre) {
                $('.statusMsg').html('<span style="color:red;">El nombre es un campo obligatorio.</span>');

            }else if (ubicacion=='0') {
                $('.statusMsg').html('<span style="color:red;">La ubicación es un campo obligatorio.</span>');

            }else if (supervisor=='0') {
                $('.statusMsg').html('<span style="color:red;">El supervisor es un campo obligatorio.</span>');

            }else if (lugar=='0') {
                $('.statusMsg').html('<span style="color:red;">El lugar es un campo obligatorio.</span>');

            }else{
                                        // Preparar datos para enviar
                    var datos = {
                        tipo : tipo,
                        nombre : nombre,
                        num : num,
                        ubicacion : ubicacion,
                        supervisor : supervisor, 
                        lugar : lugar
                    };

                    
                    //exit();
                
                // Enviar solicitud AJAX
                $.ajax({
                    type: 'POST',
                    url: 'guardar_empleado.php', // Cambiar por tu ruta PHP
                    data: datos,
                    beforeSend: function() {
                        // Deshabilitar el botón mientras se procesa la solicitud
                        $('.submitBtnx').prop('disabled', true);
                        $('.statusMsg').html('<span style="color:blue;">Procesando...</span>');
                    },
                    success: function (response) {
                        try {
                            var data = JSON.parse(response);

                            if (data.dato) {
                                // Éxito: Mostrar mensaje en verde y mantener deshabilitado
                                $('.statusMsg').html('<span style="color:green;">' + data.message + '.</span>');
                                $('.tipoMovx').val(0); // Resetear el valor del input
                                $('#nombrex').prop('disabled', true);
                                $('#ubicacionx').prop('disabled', true);
                                $('#supervisorx').prop('disabled', true);
                                $('#lugarx').prop('disabled', true);
                            } else {
                                // Error del servidor: Mostrar mensaje en rojo y habilitar de nuevo
                                $('.statusMsg').html('<span style="color:red;">' + data.message + '</span>');
                                $('.submitBtnx').prop('disabled', false);
                            }
                        } catch (e) {
                            // Error al procesar la respuesta JSON
                            $('.statusMsg').html('<span style="color:red;">Error al procesar la respuesta del servidor: ' + e.message + '</span>');
                            $('.submitBtnx').prop('disabled', false);
                        }
                    },
                    error: function (xhr, status, error) {
                        // Error en la solicitud AJAX
                        $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + status + ' - ' + error + '</span>');
                        $('.submitBtnx').prop('disabled', false);
                    },
                    complete: function () {
                        // No rehabilitar el botón aquí, ya se controla por la lógica de éxito o error
                    }
                });

            }

}

function actualizarPagina() {
    location.reload();
}

function cargarSupervisoresx(){
    var ubicacion = $('#ubicacionx').val();

    var datos = {
        ubicacion:ubicacion
    };

    $.ajax({
            type: 'POST',
            url: 'obtener_datos.php', // Cambiar por tu ruta PHP
            data: datos,
            success: function(response) {
                
                try {
                    var data = JSON.parse(response);
                    alert(data.supervisor);
                    const select = document.getElementById('supervisorx');
                    select.innerHTML='<option value="0" selected>Selecciona un supervisor</option>' + htmlOptions;
                    $('#modalAlta').find('#supervisorx').html(data.supervisor);
                    /*if (data.dato) {
                        
                        $('.statusMsg').html('<span style="color:green;">' + data.message + '.</span>'); 
                        $('.submitBtn').prop('disabled', true);
                    } else {
                        $('.statusMsg').html('<span style="color:red;">' + data.message + '</span>');
                    }*/
                } catch (e) {
                    $('.statusMsg').html('<span style="color:red;">Error al procesar la respuesta del servidor.</span>');
                }
            },
            error: function(xhr, status, error) {
                $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + error + '</span>');
            }
        });

}

function cargarSupervisores() {
        // Obtener la ubicación (puedes personalizar cómo obtienes este valor)
        const ubicacion = $('#ubicacionx').val(); // Ejemplo de ubicación, cámbialo según tu lógica
        const id = 1;
        // Configurar los datos para enviar con la solicitud
        const formData = new FormData();
        formData.append('ubicacion', ubicacion);
        formData.append('id',id);

        // Realizar la solicitud AJAX
        fetch('obtener_datos.php', { // Cambia la URL según corresponda
            method: 'POST',
            body: formData
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error en la solicitud');
                }
                return response.json(); // Procesar la respuesta como JSON
            })
            .then(data => {

                if (data.supervisor) {
                        // Obtener el select por su ID
                        const select = document.getElementById('supervisorx');
                        const select2 = document.getElementById('lugarx');

                    if(data.supervisor==0){
                        select.innerHTML = '<option value="0" selected>Selecciona un supervisor</option>';
                        select2.innerHTML = '<option value="0" selected>Selecciona un lugar</option>';
                    }else {

                       // Insertar las opciones recibidas en el select
                        select.innerHTML = '<option value="0" selected>Selecciona un supervisor</option>' + data.supervisor;
                    }
                    

                    

                    
                } else {
                    console.error('No se encontraron supervisores en la respuesta.');
                }
            })
            .catch(error => {
                alert(error);
                console.error('Error al cargar los supervisores:', error);
            });
    }

    function cargarLugares() {
        // Obtener la ubicación (puedes personalizar cómo obtienes este valor)
        const supervisor = $('#supervisorx').val(); // Ejemplo de ubicación, cámbialo según tu lógica
        const ubicacion = $('#ubicacionx').val();
        const id = 2;
        // Configurar los datos para enviar con la solicitud
        const formData = new FormData();
        formData.append('supervisor', supervisor);
        formData.append('ubicacion', ubicacion);
        formData.append('id',2);

        //alert(id);

        // Realizar la solicitud AJAX
        fetch('obtener_datos.php', { // Cambia la URL según corresponda
            method: 'POST',
            body: formData
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error en la solicitud');
                }
                return response.json(); // Procesar la respuesta como JSON
            })
            .then(data => {
                if (data.lugar) {
                    // Obtener el select por su ID
                    const select = document.getElementById('lugarx');

                    // Insertar las opciones recibidas en el select
                    select.innerHTML = '<option value="0" selected>Selecciona un lugar</option>' + data.lugar;
                } else {
                    console.error('No se encontraron lugares en la respuesta.');
                }
            })
            .catch(error => {
                console.error('Error al cargar los lugares:', error);
            });
    }    

        function closeModal() {
            document.getElementById('modalSubir').style.display = 'none';
            document.getElementById('output').innerHTML = ''; // Limpia el contenido
        }

        function processCSV() {
            const fileInput = document.getElementById('csvFile');
            const output = document.getElementById('output');

            if (!fileInput.files.length) {
                alert('Por favor, selecciona un archivo.');
                return;
            }

            const file = fileInput.files[0];
            const reader = new FileReader();

            reader.onload = function (e) {
                const text = e.target.result;
                const rows = text.split('\n').map(row => row.split(','));
                renderTable(rows, output);
            };

            reader.readAsText(file);
        }

        function renderTable(data, outputElement) {
            let table = '<table><thead><tr>';
            data[0].forEach(header => {
                table += `<th>${header.trim()}</th>`;
            });
            table += '</tr></thead><tbody>';
            data.slice(1).forEach(row => {
                table += '<tr>';
                row.forEach(cell => {
                    table += `<td>${cell.trim()}</td>`;
                });
                table += '</tr>';
            });
            table += '</tbody></table>';
            outputElement.innerHTML = table;
        }

        $(document).ready(function(){
            $('#uploadForm').on('submit', function(e){
                $('#datosx').html('');
                e.preventDefault();
                var formData = new FormData(this);
                $('#cargandoModalx').modal('show');
                $('.statusMsg1').html('<p style="text-align:center;"><img src="./img/loading2.gif" alt="Cargando"><img> Cargando información, favor de esperar..</p>');
                $.ajax({
                    type: 'POST',
                    url: 'procesarDatos.php',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(response){
                        $('.statusMsg1').html('');
                        $('#datosx').html(response);
                        $('#cargandoModalx').modal('hide');
                    },
                    error: function(xhr, status, error){
                        alert('Error: ' + error);
                    }
                });
            });
        });
</script>

</body>
</html>
