<?php
session_start();
	include '../conexion.php';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Taller</title>
    <link rel="icon" href="./icons/taller.png" type="image/png">
    <link rel="stylesheet" href="./sidemenu.css">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="wrapper">
        <main>    
            <!-- Encabezado -->
            <header>
                <?php include "includes/header2.php"; ?>
            </header>
            <div id="sidemenu" class="menu-expanded">
                <!-- Header -->
                <div id="header">
                    <div id="title"><span></span></div>
                    <div id="menu-btn">
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                    </div>
                </div>
                <!-- Items -->
                <div id="menu-items">
                    <?php include './includes/navs3.php'?>
                </div>
            </div>
            <div style="height:calc(80%); width:90%; padding-right:15px; padding-left:200px; margin-right:60px; margin-left:60px; margin-top:20px;">
                <div style="width:100%;">
                    <!-- Agregar el modal de carga -->
                    <div class="modal" id="cargandoModalx" tabindex="-1" role="dialog">
                      <div class="modal-dialog" role="document">
                        <div class="modal-content">
                          <div class="modal-body">
                            <p style="text-align:center;">
                                <img src="./img/loading2.gif" alt="Cargando"> Preparando información, favor de esperar..
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                    <table border='1' style='width:80%;'>
                        <tr>
                            <td style='text-align:right;'>
                                <label>Sucursal:</label>
                                <select id='sucursal'>
                                    <option value='0'>--Selecciona--</option>
                                    <option value='1'>TIJUANA</option>
                                    <option value='2'>ENSENADA</option>
                                    <option value='3'>MEXICALI</option>
                                </select>   
                                <label>Fecha de Entrega:</label>
                                <input type='date' id='fecha1'>
                                <button onclick='cargar()'>Cargar Datos</button>
                                <!--<button onclick='imprimirMovimiento()'>Imprimir Entrega</button>
                                <button onclick='cancelMovement()'>Cancelar Entrega</button>-->
                            </td>
                        </tr>
                    </table>
                    <div id='datosEntrega' style="width:100%;"></div>
                </div>
            </div>
        </main>
        <!-- Pie de página -->
        <footer>
            <?php include "includes/footer.php"; ?>
        </footer>
    </div>

    <!-- Incluye jQuery primero, luego Popper.js y después Bootstrap JS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        const btn = document.querySelector('#menu-btn');
        const menu = document.querySelector('#sidemenu');

        btn.addEventListener('click', e => {
            menu.classList.toggle("menu-expanded");
            menu.classList.toggle("menu-collapsed");
            document.querySelector('body').classList.toggle('body-expanded');
        });
    </script>

    <script type="text/javascript">
        function cargar(){
            var fecha = $('#fecha1').val();
            var ubicacion = $('#sucursal').val();
            //alert(ubicacion);
            
            if (!fecha) {
                alert("Por favor, selecciona una fecha.");
                return;
            } 
            else if(ubicacion==0) {
                alert("Por favor, selecciona sucursal.");
                return;
            } else{
                $('#cargandoModalx').modal('show');
                $.ajax({
                type: "POST",
                url: "datosEntrega.php",
                data: { fecha: fecha,sucursal:ubicacion },
                success: function(r) {
                    $('#cargandoModalx').modal('hide');
                    $('#datosEntrega').html(r);
                },
                error: function(xhr, status, error) {
                    console.error("Error en la solicitud AJAX:", status, error);
                    alert("Hubo un problema con la solicitud. Por favor, inténtalo de nuevo.");
                }
            });
            }

            
        }
     
        
    </script>
</body>
</html>

