<?php
include '../conexion.php';


//header('Content-Type: application/json'); // Para asegurarte de que devuelves un JSON
//$response = array();

function ubica($tr){
    $ubica=null;
    switch($tr){
        case 'TIJUANA': $ubica='1'; break;
        case 'ENSENADA': $ubica='2'; break;
        case 'MEXICALI': $ubica='3'; break;
        case 'ROSARITO': $ubica='1'; break;
    }

    return $ubica;
}

    // Verificar que la solicitud sea POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método no permitido.');
    }

    // Recibir los datos enviados
    $empleado = isset($_POST['empleado']) ? trim($_POST['empleado']) : null;
    $fecha = isset($_POST['fecha']) ? trim($_POST['fecha']) : null;
    $datosTabla = isset($_POST['datosTabla']) ? json_decode($_POST['datosTabla'], true) : [];

    
    // Validar que datosTabla sea un array
    if (!is_array($datosTabla)) {
        throw new Exception('Formato incorrecto en los datos de la tabla.');
    }

    // Aquí puedes agregar lógica para guardar los datos en la base de datos
    // Ejemplo de conexión a la base de datos
    

    if ($connection->connect_error) {
        throw new Exception('Error al conectar a la base de datos: ' . $connection->connect_error);
    }

    // Iniciar una transacción
    $connection->begin_transaction();

    try {
        //obtener nombre de empleado
        $stmt = $connection->prepare("SELECT * FROM uni_empleados WHERE num_emp = ?");
        $stmt->bind_param("s", $empleado); // Cambié el tipo a "i" para entero
        $stmt->execute();
        $result = $stmt->get_result();

        $dato1=null;
        $dato2=null;
        $dato3=null;

        while ($row = $result->fetch_assoc()) {
            $dato1=$row['nombre'];
            $dato2=$row['ubicacionCompleta'];
            $dato3=$row['lugar_trabajo'];
            $ubicacion=ubica($row['ubicacion']);
        }
        

       // $stmt->close();
        $hoy=date('Y-m-d');
        $idTipoMov='4';

        // Insertar los datos principales de la factura
        $stmt = $connection->prepare("INSERT INTO uni_movimientos (fechaMov, fechaCaptura, dato1,dato2,dato3, uni_tipomov_idtipoMovUni) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssss", $fecha, $hoy, $dato1, $dato2, $dato3, $idTipoMov);

        // Ejecuta la consulta
        if ($stmt->execute()) {
            // Obtén el último ID insertado
            $ultimoId = $connection->insert_id;
            //echo "El último ID insertado es: " . $ultimoId;
        } else {
            echo "Error al ejecutar la consulta: " . $stmt->error;
        }

       
        // Insertar los datos de la tabla dinámica
        $stmtDetalle = $connection->prepare("INSERT INTO uni_detmovimiento (ubicacion,uni_uniforme_iduniforme,cant,uni_movimientos_idmovimientosUni,uni_usuario_idusuarioUni) VALUES (?, ?, ?, ?,?)");

        foreach ($datosTabla as $fila) {
            // Suponiendo que cada fila tiene campos 'campo1', 'campo2' y 'campo3'
            
            $uniforme = isset($fila['id[]']) ? $fila['id[]'] : null;
            $cantidad = isset($fila['cant[]']) ? $fila['cant[]'] : null;


            if (!$uniforme ) {
                throw new Exception('Los campos de la tabla no pueden estar vacíos.');
            }
            
            $usuario='1';
            //$cantidad='1';
            $stmtDetalle->bind_param("iisii", $ubicacion, $uniforme, $cantidad,$ultimoId,$usuario);
            $stmtDetalle->execute();

            //obtener inventario
            $inv=null;
            switch($ubicacion){
                case '1': $inv="inv1"; break;
                case '2': $inv="inv2";break;
                case '2': $inv="inv3";break;
            }
            $stmtinv = $connection->prepare("SELECT $inv FROM uni_uniforme WHERE iduniforme=?");
            $stmtinv->bind_param("i", $uniforme);
            $stmtinv->execute();
            $resultinv = $stmtinv->get_result();

            while ($rowinv = $resultinv->fetch_assoc()) {
                $existencia=$rowinv[$inv];
            }
       // $stmt->close();
        // actualizar inventario
            $ncant=$existencia-$cantidad;
            $stmtupdate = $connection->prepare("update uni_uniforme set $inv=? where iduniforme=?");
            $stmtupdate->bind_param("ii", $ncant,$uniforme);
            $stmtupdate->execute();
        }
        $stmtDetalle->close();

        // Confirmar la transacción
        $connection->commit();
        $response['success'] = true;
        $response['id'] = $ultimoId;
    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $connection->rollback();
        throw $e;
    } finally {
        $connection->close();
    }


// Devolver la respuesta como JSON
http_response_code($response['success'] ? 200 : 400);
echo json_encode($response);
?>