<?php
include '../conexion.php';


//header('Content-Type: application/json'); // Para asegurarte de que devuelves un JSON
//$response = array();



    // Verificar que la solicitud sea POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método no permitido.');
    }

    // Recibir los datos enviados
    $proveedor = isset($_POST['proveedor']) ? trim($_POST['proveedor']) : null;
    $fecha = isset($_POST['fecha']) ? trim($_POST['fecha']) : null;
    $moneda = isset($_POST['moneda']) ? trim($_POST['moneda']) : null;
    $factura = isset($_POST['factura']) ? trim($_POST['factura']) : null;
    $iva = isset($_POST['iva']) ? floatval($_POST['iva']) : null;
    $retencion = isset($_POST['retencion']) ? floatval($_POST['retencion']) : null;
    $subtotal = isset($_POST['subtotal']) ? floatval($_POST['subtotal']) : null;
    $total = isset($_POST['total']) ? floatval($_POST['total']) : null;
    $sucursal = isset($_POST['sucursal']) ? floatval($_POST['sucursal']) : null;
    $datosTabla = isset($_POST['datosTabla']) ? json_decode($_POST['datosTabla'], true) : [];
    $ultimoId=null;
    $nombreProveedor=null;
    $ncant=0;
    // Validar datos obligatorios
    
    
    // Validar que datosTabla sea un array
    if (!is_array($datosTabla)) {
        throw new Exception('Formato incorrecto en los datos de la tabla.');
    }

    // Aquí puedes agregar lógica para guardar los datos en la base de datos
    // Ejemplo de conexión a la base de datos
    

    if ($connection->connect_error) {
        throw new Exception('Error al conectar a la base de datos: ' . $connection->connect_error);
    }

    // Iniciar una transacción
    $connection->begin_transaction();

    try {
        //obtener nombre de proveedor
        $stmt = $connection->prepare("SELECT * FROM uni_proveedor WHERE idproveedorUni = ?");
        $stmt->bind_param("i", $proveedor); // Cambié el tipo a "i" para entero
        $stmt->execute();
        $result = $stmt->get_result();

        while ($row = $result->fetch_assoc()) {
            $nombreProveedor=$row['nombre'];
        }
       // $stmt->close();
$hoy=date('Y-m-d');
$idTipoMov='1';
        // Insertar los datos principales de la factura
        $stmt = $connection->prepare("INSERT INTO uni_movimientos (fechaMov, fechaCaptura, dato1, uni_tipomov_idtipoMovUni) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $fecha, $hoy, $nombreProveedor, $idTipoMov);

        // Ejecuta la consulta
        if ($stmt->execute()) {
            // Obtén el último ID insertado
            $ultimoId = $connection->insert_id;
            //echo "El último ID insertado es: " . $ultimoId;
        } else {
            echo "Error al ejecutar la consulta: " . $stmt->error;
        }

        // Cierra la declaración
       // $stmt->close();

        $stmt = $connection->prepare("INSERT INTO uni_factura (fechaFactura, factura, moneda, iva, retencion, subtotal, total,uni_proveedor_idproveedorUni,uni_movimientos_idmovimientosUni,sucursal) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssddddiis", $fecha, $factura, $moneda, $iva, $retencion, $subtotal, $total, $proveedor, $ultimoId,$sucursal);
        $stmt->execute();

        // Obtener el ID de la factura recién insertada
        $facturaId = $stmt->insert_id;
        $stmt->close();

        // Insertar los datos de la tabla dinámica
        $stmtDetalle = $connection->prepare("INSERT INTO uni_detmovimiento (ubicacion,uni_uniforme_iduniforme,cant,costo,uni_movimientos_idmovimientosUni,uni_usuario_idusuarioUni) VALUES (?, ?, ?, ?, ?,?)");

        foreach ($datosTabla as $fila) {
            // Suponiendo que cada fila tiene campos 'campo1', 'campo2' y 'campo3'
            
            $uniforme = isset($fila['id[]']) ? $fila['id[]'] : null;
            $cantidad = isset($fila['cantidad[]']) ? $fila['cantidad[]'] : null;
            $costo = isset($fila['costo[]']) ? $fila['costo[]'] : null;
            

            if (!$uniforme || !$cantidad || !$costo) {
                throw new Exception('Los campos de la tabla no pueden estar vacíos.');
            }
            $ubicacion='1';
            $usuario='1';
            $stmtDetalle->bind_param("iissii", $ubicacion, $uniforme, $cantidad, $costo,$ultimoId,$usuario);
            $stmtDetalle->execute();

            //obtener inventario
            $inv=null;
            if($sucursal=="1"){
                $inv="inv1";
            } else if($sucursal=="2"){
                $inv="inv2";

            }else if($sucursal=="3"){
                $inv="inv3";

            }

            $stmtinv = $connection->prepare("SELECT ".$inv." FROM uni_uniforme WHERE iduniforme=?");
            $stmtinv->bind_param("i", $uniforme);
            $stmtinv->execute();
            $resultinv = $stmtinv->get_result();

            while ($rowinv = $resultinv->fetch_assoc()) {
                $existencia=$rowinv[$inv];
            }
       // $stmt->close();
        // actualizar inventario
            $ncant=$existencia+$cantidad;
            $stmtupdate = $connection->prepare("update uni_uniforme set ".$inv."=? where iduniforme=?");
            $stmtupdate->bind_param("ii", $ncant,$uniforme);
            $stmtupdate->execute();
        }
        $stmtDetalle->close();

        // Confirmar la transacción
        $connection->commit();
        $response['success'] = true;
        //$response['message'] = 'Factura guardada exitosamente.';
    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $connection->rollback();
        throw $e;
    } finally {
        $connection->close();
    }


// Devolver la respuesta como JSON
http_response_code($response['success'] ? 200 : 400);
echo json_encode($response);
?>