<?php
include '../conexion.php';
mysqli_set_charset($connection, "utf8");

$response = array();

// Función para enviar la respuesta como JSON
function sendResponse($success, $message, $data = null) {
    http_response_code($success ? 200 : 400);
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'dato' => $data
    ]);
    exit;
}

// Verificar que la solicitud sea POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Método no permitido.');
}

// Recibir los datos enviados
$tipo = isset($_POST['tipo']) ? trim($_POST['tipo']) : null;
//$medida = isset($_POST['medida']) ? trim($_POST['medida']) : null;
$medida = isset($_POST['medida']) ? preg_replace('/\s{1,}/', '', trim($_POST['medida'])) : null;



    if (empty($tipo) || empty($medida)) {
        sendResponse(false, 'Datos incompletos para el registro.');
    }

    $connection->begin_transaction();

    try {
        $stmtx = $connection->prepare("SELECT * FROM uni_medidas WHERE medida = ? and uni_tipo_idtipoUni=?");
        $stmtx->bind_param("ss", $medida,$tipo);
        $stmtx->execute();
        $result = $stmtx->get_result();

        if ($result->num_rows > 0) {
            sendResponse(true, 'Medida ya existe.', false);
        }

        $stmtx = $connection->prepare("SELECT max(orden) as orden FROM uni_medidas WHERE uni_tipo_idtipoUni=?");
        $stmtx->bind_param("s", $tipo);
        $stmtx->execute();
        $result = $stmtx->get_result();

        $max=null;

        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $max=$row['orden']+1;
            }
            
        }

        $stmt = $connection->prepare("INSERT INTO uni_medidas(orden,medida,uni_tipo_idtipoUni) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $max, $medida, $tipo);
        $stmt->execute();

        $connection->commit();
        sendResponse(true, 'Medida registrada con éxito.', true);

    } catch (Exception $e) {
        $connection->rollback();
        sendResponse(false, 'Error al registrar empleado: ' . $e->getMessage());
    } finally {
        $stmtx->close();
        $stmt->close();
        $connection->close();
    }


?>
