<?php
include '../conexion.php';
mysqli_set_charset($connection, "utf8");


function ubicacion($s){
    $ubica=null;
    switch($s){
        case '1': $ubica="TIJUANA";break;
        case '2': $ubica="ENSENADA";break;
        case '3': $ubica="MEXICALI";break;
    }
    return $ubica;
}

    // Verificar que la solicitud sea POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método no permitido.');
    }

    // Recibir los datos enviados
    $origen = isset($_POST['origen']) ? trim($_POST['origen']) : null;
    $destino = isset($_POST['destino']) ? trim($_POST['destino']) : null;
    $fecha = isset($_POST['fecha']) ? trim($_POST['fecha']) : null;
    $datosTabla = isset($_POST['datosTabla']) ? json_decode($_POST['datosTabla'], true) : [];

    
    // Validar que datosTabla sea un array
    if (!is_array($datosTabla)) {
        throw new Exception('Formato incorrecto en los datos de la tabla.');
    }

    // Aquí puedes agregar lógica para guardar los datos en la base de datos
    // Ejemplo de conexión a la base de datos
    

    if ($connection->connect_error) {
        throw new Exception('Error al conectar a la base de datos: ' . $connection->connect_error);
    }

    // Iniciar una transacción
    $connection->begin_transaction();

    try {

       // $stmt->close();
        $hoy=date('Y-m-d');
        $idTipoMov='2';
        $dato1="TRASPASO";
        $o=ubicacion($origen);
        $d=ubicacion($destino);
        // Insertar los datos principales de la factura
        $stmt = $connection->prepare("INSERT INTO uni_movimientos (fechaMov, fechaCaptura, dato1,dato2,dato3, uni_tipomov_idtipoMovUni) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssss", $fecha, $hoy, $dato1, $o, $d, $idTipoMov);

        // Ejecuta la consulta
        if ($stmt->execute()) {
            // Obtén el último ID insertado
            $ultimoId = $connection->insert_id;
            //echo "El último ID insertado es: " . $ultimoId;
        } else {
            echo "Error al ejecutar la consulta: " . $stmt->error;
        }

       
        // Insertar los datos de la tabla dinámica
        $stmtDetalle = $connection->prepare("INSERT INTO uni_detmovimiento (ubicacion,uni_uniforme_iduniforme,cant,uni_movimientos_idmovimientosUni,uni_usuario_idusuarioUni) VALUES (?, ?, ?, ?,?)");

        foreach ($datosTabla as $fila) {
            // Suponiendo que cada fila tiene campos 'campo1', 'campo2' y 'campo3'
            
            $uniforme = isset($fila['id[]']) ? $fila['id[]'] : null;
            $cantidad = isset($fila['cant[]']) ? $fila['cant[]'] : null;


            if (!$uniforme ) {
                throw new Exception('Los campos de la tabla no pueden estar vacíos.');
            }
            
            $usuario='1';
            //$cantidad='1';
            $stmtDetalle->bind_param("iisii", $origen, $uniforme, $cantidad,$ultimoId,$usuario);
            $stmtDetalle->execute();

            //obtener inventario
            $invo=null;
            $invd=null;
            switch($origen){
                case '1': $invo="inv1"; break;
                case '2': $invo="inv2";break;
                case '3': $invo="inv3";break;
            }
            switch($destino){
                case '1': $invd="inv1"; break;
                case '2': $invd="inv2";break;
                case '3': $invd="inv3";break;
            }
            $stmtinv = $connection->prepare("SELECT $invo,$invd FROM uni_uniforme WHERE iduniforme=?");
            $stmtinv->bind_param("i", $uniforme);
            $stmtinv->execute();
            $resultinv = $stmtinv->get_result();

            while ($rowinv = $resultinv->fetch_assoc()) {
                $existencia=$rowinv[$invo];
                $existenciad=$rowinv[$invd];
            }
       // $stmt->close();
        // actualizar inventario
            $ncant=$existencia-$cantidad;
            $ncantd=$existenciad+$cantidad;
            $stmtupdate = $connection->prepare("update uni_uniforme set $invo=?,$invd=? where iduniforme=?");
            $stmtupdate->bind_param("iii", $ncant, $ncantd,$uniforme);
            $stmtupdate->execute();
        }
        $stmtDetalle->close();

        // Confirmar la transacción
        $connection->commit();
        $response['success'] = true;
        $response['id'] = $ultimoId;
    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $connection->rollback();
        throw $e;
    } finally {
        $connection->close();
    }


// Devolver la respuesta como JSON
http_response_code($response['success'] ? 200 : 400);
echo json_encode($response);
?>