<?php
// Define the base path for the library if not already defined
if (!defined('_MPDF_PATH')) {
    define('_MPDF_PATH', __DIR__ . '/libs/mpdf/');
}

// Register the mPDF classes
spl_autoload_register(function ($class) {
    $prefix = 'Mpdf\\';
    $base_dir = _MPDF_PATH . 'src/';

    // Check if the class uses the prefix
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // no, move to the next registered autoloader
        return;
    }

    // Get the relative class name
    $relative_class = substr($class, $len);

    // Replace the namespace prefix with the base directory, replace namespace
    // separators with directory separators in the relative class name, append
    // with .php
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    // If the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
});

// Avoid redefining constants and manually loading classes
