<?php
session_start();
include '../conexion.php';

$idfactura = $_POST['idfactura'] ?? null;
$fecha=null;
$proveedor=null;
$idmov=null;
$factura=null;
$moneda=null;
$iva=null;
$retencion=null;
$subtotal=null;
$total=null;

$fila=null;

if (empty($idfactura)) {
    die("El ID de factura no puede estar vacío.");
}

$stmt = $connection->prepare("SELECT * FROM datos_facturas WHERE uni_movimientos_idmovimientosUni = ?");
$stmt->bind_param("s", $idfactura);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $fecha=htmlspecialchars($row['fechaFactura']);
            $proveedor=htmlspecialchars($row['uni_proveedor_idproveedorUni']);
            $idmov=htmlspecialchars($row['uni_movimientos_idmovimientosUni']);
            $factura=htmlspecialchars($row['factura']);
            $moneda=htmlspecialchars($row['moneda']);
            $iva=htmlspecialchars($row['iva']);
            $retencion=htmlspecialchars($row['retencion']);
            $subtotal=htmlspecialchars($row['subtotal']);
            $total=htmlspecialchars($row['total']);
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}

$stmt = $connection->prepare("SELECT * FROM datos_compras WHERE idmovimientosUni = ?");
$stmt->bind_param("s", $idmov);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $fila=null;
        while ($row = $result->fetch_assoc()) {
            $fila .= '<tr><td style="width:10%"><input disabled style="font-size: 12px;" type="text" class="form-control" name="idw[]" value="'.$row['uni_uniforme_iduniforme'].'" size="3"></td>
                            <td style="width:50%"><input disabled style="font-size: 12px;" type="text" class="form-control" name="uniformew[]" value="'.$row['descrip'].'"></td>
                            <td style="width:10%"><input disabled style="font-size: 12px;text-align:right;" type="text" class="form-control" name="cantidadw[]" oninput="calcularImportew(this)" value="'.$row['cant'].'"></td>
                            <td style="width:10%"><input disabled style="font-size: 12px;text-align:right;" type="text" class="form-control" name="costow[]" oninput="calcularImportew(this)" value="'.$row['costo'].'"></td>
                            <td style="width:10%"><input disabled style="font-size: 12px;text-align:right;" type="text" class="form-control" name="importew[]" value="'.$row['cant']*$row['costo'].'"></td>
                            <td style="width:10%"><button disabled type="button" class="btn btn-danger" onclick="eliminarFilaTablaw(this)"><i class="fa-solid fa-eraser"></i></button></td>
                            </tr>';
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}

$stmt->close();
$connection->close();

$mensaje = array(
    'fecha' => $fecha,
    'proveedor'=>$proveedor,
    'factura'=>$factura,
    'moneda'=>$moneda,
    'iva'=>number_format($iva,2),
    'retencion'=>number_format($retencion,2),
    'subtotal'=>number_format($subtotal,2),
    'total'=>number_format($total,2),
    'fila'=>$fila
);
    
echo json_encode($mensaje);		
?>