<?php
session_start();
include '../conexion.php';

$idfactura = $_POST['idfactura'] ?? null;
$fecha=null;
$proveedor=null;
$idmov=null;
$factura=null;
$moneda=null;
$iva=null;
$retencion=null;
$subtotal=null;
$total=null;

$fila=null;

if (empty($idfactura)) {
    die("El ID de factura no puede estar vacío.");
}

$stmt = $connection->prepare("SELECT * FROM datos_facturas WHERE uni_movimientos_idmovimientosUni = ?");
$stmt->bind_param("s", $idfactura);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $fecha=htmlspecialchars($row['fechaFactura']);
            $proveedor=htmlspecialchars($row['nombre']);
            $idmov=htmlspecialchars($row['uni_movimientos_idmovimientosUni']);
            $factura=htmlspecialchars($row['factura']);
            $subtotal=htmlspecialchars($row['subtotal']);
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}


$stmt->close();
$connection->close();

$mensaje = array(
    'fecha' => $fecha,
    'proveedor'=>$proveedor,
    'factura'=>$factura,
    'subtotal'=>number_format($subtotal,2),
    'idmov'=>$idmov

);
    
echo json_encode($mensaje);		
?>