<?php
session_start();
include '../conexion.php';
$subtotal=null;    
mysqli_set_charset($connection, "utf8");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Taller</title> <link rel="icon" href="./icons/taller.png" type="image/png">
    <link rel="stylesheet" href="./sidemenu.css">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="./sidemenu.css">
    <!-- jQuery library -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>

<!-- Latest minified bootstrap js -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>



</head>
<body  >
    <div class="wrapper">
        <main>    
            <!-- Encabezado -->
            <header>
                <!--<h1>Taller</h1>-->
                <?php include "includes/header2.php"; ?>
            </header>

            <!--<div id="sidemenu" class="menu-collapsed">-->
            <div id="sidemenu" class="menu-expanded">
                <!-- Header -->
                <div id="header">
                    <div id="title"><span></span> </div>
                    <div id="menu-btn">
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                    </div>
                </div>
                <!--Profile-->
                <!--<div id="profile">
                    <div id="photo"><img src="img/user.png" alt=""></div>
                    <div id="name"><span><?php echo $_SESSION['nombre'];?></span></div>
                    <div id="name"><span><?php echo $_SESSION['iduser']." [ ".$_SESSION['user']." ] ";?></span></div>
                    <div id="name"><span><?php echo "Sucursal: ".$_SESSION['suc'];?></span></div>
                    <div id="name"><span> <?php echo "Rol: ".$_SESSION['rol'];?></span></div>
                </div>-->
                <!--Items-->
                <div id="menu-items">
                    <?php include './includes/navs3.php'?>
                </div>
            </div>

            <div style="height:calc(100%); width:90%; padding-right:15px; padding-left:200px; margin-right:60px; margin-left:60px;margin-top:20px;">

            
            <div style="width:100%;">
                <table border='0' style='width:100%;'>
                    <tr>
                    <td style='text-align:right;'><button class="btn btn-primary btn-sm" onclick="actualizarPagina()"><i class="fa-solid fa-arrows-rotate"></i></button>
                    <button style="margin-right:15px;" class="btn btn-success btn-sm" data-backdrop="static" data-keyboard="false" data-toggle="modal" data-target="#modalAltauniforme"><i class="fa-solid fa-circle-plus"></i></button>
                    <input ID="busqueda" type="text" autocomplete="off" style="width:200px;"placeholder="Captura dato a buscar" onkeydown="if (event.key === 'Enter') buscar()">
                        <button id="btnBusqueda" class="btn btn-primary btn-sm" type="button" onclick="buscar()"><i class="fa-solid fa-magnifying-glass"></i></button>
                    </td>
                </tr>
                </table>
                <div class="table-container" style="width:100%;heigth:100%">
                    <table border='0' style='width:100%;font-size:8pt;'>
                        <thead>
                            <tr>
                                <th style="width:5%;">id</th>
                                <th style="width:10%;">Orden</th>
                                <th style="width:65%;">Descripcion</th>
                                <!--<th style='text-align:center;'>Monto</th>-->
                                <th style="width:30%;">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        $busq = filter_input(INPUT_GET, 'busqueda', FILTER_SANITIZE_STRING) ?: '';
                        $pagina = filter_input(INPUT_GET, 'pagina', FILTER_VALIDATE_INT) ?: 1;

                        $por_pagina = 15;
                        $desde = ($pagina - 1) * $por_pagina;

                        // Total registros
                        $query_total = "SELECT COUNT(*) as total_registros FROM datos_uniformes WHERE u_descripcion like ? OR medida LIKE ?";
                        $stmt = $connection->prepare($query_total);
                        $likeBusq = "%{$busq}%";
                        $stmt->bind_param("ss", $likeBusq, $likeBusq);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        $total_registros = $result->fetch_assoc()['total_registros'];

                        $total_paginas = ceil($total_registros / $por_pagina);

                        // Consulta principal
                        $query = "SELECT * FROM datos_uniformes WHERE u_descripcion like ? OR medida LIKE ? ORDER BY ordena ASC LIMIT ?, ?";
                        $stmt = $connection->prepare($query);
                        $stmt->bind_param("ssii", $likeBusq, $likeBusq, $desde, $por_pagina);
                        $stmt->execute();
                        $result = $stmt->get_result();

                        if ($result->num_rows > 0) {
                            while ($data = $result->fetch_assoc()) {
                                $id = htmlspecialchars($data['iduniforme'], ENT_QUOTES, 'UTF-8');
                                $check=null;
                                $estado='Inactivo';
                                if($data['activo']==1){
                                    $check='checked';
                                    $estado='Activo';
                                } 

                                echo "<tr>
                                        <td style='text-align:left;padding-left:20px'>{$id}</td>
                                        <td style='text-align:left;padding-left:20px'>" . htmlspecialchars($data['ordena'], ENT_QUOTES, 'UTF-8') . "</td>
                                        <td style='text-align:left;padding-left:20px'>" . htmlspecialchars($data['u_descripcion'] . " " . $data['medida'] . " " . $data['estado'], ENT_QUOTES, 'UTF-8') . "</td>
                                        <td>
                                            <!--<div class='custom-control custom-switch'>
                                                <input $check type='checkbox' class='custom-control-input' id='customSwitch{$id}'>
                                                <label class='custom-control-label' for='customSwitch{$id}'>$estado</label>
                                            </div>-->
                                        </td>
                                    </tr>";
                            }
                        }
                        
                        ?>

                            <!-- Agrega más filas según sea necesario -->
                        </tbody>
                    </table>
                </div>
                <div class="paginador">
                    <ul><?php
                        $numeroInicio=1;
                        if($pagina!=1){
                        //$numeroInicio=1;
                        
                    ?>
                        
                        <li><a href="?pagina=<?php echo $numeroInicio?>&busqueda=<?php echo $busq?>"><i class="fa-solid fa-backward-fast"></i></a></li>
                        <!--<li><a href="?pagina=<?php /*echo $pagina-1*/?>"><<</a></li>-->
                        <?php 
                        }
                            if(($pagina-3)>1){
                                $numeroInicio=$pagina-3;
                            }
                            $numeroFin=$numeroInicio+4;
                            
                            if($numeroFin>$total_paginas){
                                $numeroFin=$total_paginas;
                            }
                            
                            for($i=$numeroInicio;$i<=$numeroFin;$i++){
                                if($i==$pagina){
                                    echo '<li class="pageSelected">'.$i.'</li>';
                                } else{
                                echo '<li><a href="?pagina='.$i.'&busqueda='.$busq.'">'.$i.'</a></li>';
                                }
                            }
                            if($pagina!=$total_paginas){
                                echo '<li><a href="?pagina='.$total_paginas.'&busqueda='.$busq.'"><i class="fa-solid fa-forward-fast"></i></a></li>';
                            }
                        ?>
                                        
                        
                    </ul>
                </div>
            </div>
            

            </div>


            




        </main>
            <!-- Pie de página -->
            <footer>
                <?php include "includes/footer.php"; ?>
            </footer>
    </div>




<!-- Modal view-->
<div class="modal fade" id="modalAltauniforme" role="dialog" >
    <div class="modal-dialog" >
        <div class="modal-content" style="width:600px;">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Alta Uniforme</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body" >
                <p class="statusMsg"></p>    
                <form role="form">
                <table >
				<tr>
				<td colspan="3" style="text-align:left;">
				<div class="form-group">
                        <input style="font-size: 12px;" type="hidden" class="form-control" id="id"/>
                        <input style="font-size: 12px;" type="hidden" class="form-control" id="tipoMovx" value="1"/>
                        <label style="font-size: 12px;" for="uniforme">Descripción:</label>
						<input style="font-size: 12px;" type="text" autocomplete="off" class="form-control" id="uniforme" />
                    </div>
				</td>
                </tr>
                <tr>
                <td  style="text-align:left;width:33%">
				<div class="form-group">
                        <label style="font-size: 12px;" for="tipox">Tipo:</label>
                        <select style="width:100%" class="form-control" id="tipox" onchange="obtenerMedida()">
                        <option selected value="0">--Selecciona--</option>    
                        <?php
                        $stmt = $connection->prepare("SELECT * FROM uni_tipo");
                        //$stmt->bind_param("s", $idUsuario);
                    
                        if ($stmt->execute()) {
                            $result = $stmt->get_result();
                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo '<option value="'.$row['idtipoUni'].'">'.$row['tipoUniforme'].'</option>';
                                }
                            } else {
                                echo "No se encontraron registros.";
                            }
                        } else {
                            echo "Error en la consulta: " . $stmt->error;
                        }
                        
                        ?>

                        </select>
                    </div>
				</td>
                <td  style="text-align:left;width:33%">
				<div class="form-group">
                        <label style="font-size: 12px;" for="medida">Medida:</label>
                        <select style="width:100%" class="form-control" id="medida">
                        <option value="0">--Selecciona--</option>    
                        

                        </select>
                    </div>
				</td>
                <td  style="text-align:left;width:34%">
				<div class="form-group">
                        <label style="font-size: 12px;" for="estado">Estado:</label>
                        <select style="width:100%" class="form-control" id="estado">
                        <option value="0">--Selecciona--</option>    
                        <option value="1">NUEVO</option>
                        <option value="2">USADO</option>
                        </select>
                    </div>
				</td>
                        </tr>
                        </table >
                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <button type="button" class="btn btn-primary submitBtnx" onclick="guardarUniforme()">GUARDAR</button>
            </div>
        </div>
    </div>
</div>


    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        const btn = document.querySelector('#menu-btn');
        const menu = document.querySelector('#sidemenu');

        btn.addEventListener('click', e => {
            menu.classList.toggle("menu-expanded");
            menu.classList.toggle("menu-collapsed");

            document.querySelector('body').classList.toggle('body-expanded')
        });
    

        $(document).on('click', '[data-target="#modalAltauniforme"]', function () {
            //cargarSupervisores();
        });

$(document).on('click', '[data-target="#modalEmpleado"]', function () {
    // Capturamos el valor del atributo `data-id`
    var idUsuario = $(this).data('id');
    
    // Realizamos la solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'obtener_empleado.php', // Cambia esto por el nombre de tu archivo PHP 
        data: { idUsuario: idUsuario },
        success: function(response) {
            alert(response);
            try {
                var data = JSON.parse(response); // Parsea la respuesta JSON
                $('#modalEmpleado').find('#id').val(data.id);
                $('#modalEmpleado').find('#nombre').val(data.nombre);
                $('#modalEmpleado').find('#numEmp').val(data.num);
                $('#modalEmpleado').find('#supervisor').val(data.supervisor);
                $('#modalEmpleado').find('#lugar').val(data.lugar);
                $('#modalEmpleado').find('#ubicacion').val(data.ubicacion);
                // Abrimos el modal
                //$('.submitBtn').prop('disabled', true);
                $('.submitBtn').prop('disabled', false);
            } catch (e) {
                console.error('Error procesando los datos del servidor: ', e);
                alert('Error al cargar los datos. Intente nuevamente.');
            }
        },
        error: function() {
            alert('Ocurrió un error al obtener los datos. Por favor, inténtelo más tarde.');
        }
    });
});


function buscar() {
    // Obtiene el valor del input con ID "busqueda"
    const busqueda = document.getElementById("busqueda").value;
    
    // Define la página que deseas agregar (puedes cambiar este valor)
    //const pagina = <?php echo isset($_GET['pagina']) ? json_encode($_GET['pagina']) : '1'; ?>;
    const pagina = '1';
    // Obtén la URL actual
    let url = new URL(window.location.href);

    // Agrega o actualiza los parámetros "buscar" y "pagina"
    url.searchParams.set("busqueda", busqueda);
    url.searchParams.set("pagina", pagina);

    // Redirige a la URL modificada
    window.location.href = url.toString();
}



function guardarUniforme() {
        
        var medida = $('#medida').val();
        var tipo = $('#tipox').val();
        var estado = $('#estado').val();
        var uniforme = $('#uniforme').val();
        var seguro=1;


            if (!uniforme) {
                $('.statusMsg').html('<span style="color:red;">La descripcion es un campo obligatorio.</span>');

            }else if (tipo=='0') {
                $('.statusMsg').html('<span style="color:red;">El tipo es un campo obligatorio.</span>');

            }else if (medida=='0') {
                $('.statusMsg').html('<span style="color:red;">La medida es un campo obligatorio.</span>');

            }
            else if (estado=='0') {
                $('.statusMsg').html('<span style="color:red;">El estado es un campo obligatorio.</span>');

            }else{
                                        // Preparar datos para enviar
                    var datos = {
                        seguro : seguro,
                        medida : medida,
                        tipo : tipo,
                        estado : estado,
                        uniforme : uniforme 

                    };
                    

                    // Enviar solicitud AJAX
                $.ajax({
                    type: 'POST',
                    url: 'guardar_uniforme.php', // Cambiar por tu ruta PHP
                    data: datos,
                    beforeSend: function() {
                        // Deshabilitar el botón mientras se procesa la solicitud
                        $('.submitBtnx').prop('disabled', true);
                        $('.statusMsg').html('<span style="color:blue;">Procesando...</span>');
                    },
                    success: function (response) {

                        try {
                            var data = JSON.parse(response);

                            if (data.dato) {
                                // Éxito: Mostrar mensaje en verde y mantener deshabilitado
                                $('.statusMsg').html('<span style="color:green;">' + data.message + '.</span>');

                            } else {
                                // Error del servidor: Mostrar mensaje en rojo y habilitar de nuevo
                                $('.statusMsg').html('<span style="color:red;">' + data.message + '</span>');
                                $('.submitBtnx').prop('disabled', false);
                            }
                        } catch (e) {
                            // Error al procesar la respuesta JSON
                            $('.statusMsg').html('<span style="color:red;">Error al procesar la respuesta del servidor: ' + e.message + '</span>');
                            $('.submitBtnx').prop('disabled', false);
                        }
                    },
                    error: function (xhr, status, error) {
                        // Error en la solicitud AJAX
                        $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + status + ' - ' + error + '</span>');
                        $('.submitBtnx').prop('disabled', false);
                    },
                    complete: function () {
                        // No rehabilitar el botón aquí, ya se controla por la lógica de éxito o error
                    }
                });

            }

}

function actualizarPagina() {
    location.reload();
}

function obtenerMedida(){

        const tipo = $('#tipox').val(); // Ejemplo de ubicación, cámbialo según tu lógica
        const id = 3;
        // Configurar los datos para enviar con la solicitud
        const formData = new FormData();
        formData.append('tipo', tipo);
        formData.append('id',id);

        
        // Realizar la solicitud AJAX
        fetch('obtener_datos.php', { // Cambia la URL según corresponda
            method: 'POST',
            body: formData
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error en la solicitud');
                }
                return response.json(); // Procesar la respuesta como JSON
            })
            .then(data => {

                if (data.lugar) {
                        // Obtener el select por su ID
                        const select = document.getElementById('medida');
                        const select2 = document.getElementById('estado');

                    if(data.lugar==0){
                        select.innerHTML = '<option value="0" selected>--Selecciona--</option>';
                        select2.innerHTML = '<option value="0" selected>--Selecciona--</option>';
                    }else {

                       // Insertar las opciones recibidas en el select
                        select.innerHTML = '<option value="0" selected>--Selecciona--</option>' + data.lugar;
                        select2.innerHTML = '<option value="0" selected>--Selecciona--</option><option value="1">NUEVO</option><option value="2">USADO</option>';
                    }
                    
                } else {
                    console.error('No se encontraron supervisores en la respuesta.');
                }
            })
            .catch(error => {
                alert(error);
                console.error('Error al cargar los supervisores:', error);
            });

}



</script>

</body>
</html>
