<?php
session_start();
include '../conexion.php';
$subtotal=null;    
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Taller</title> <link rel="icon" href="./icons/taller.png" type="image/png">
    <link rel="stylesheet" href="./sidemenu.css">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="./sidemenu.css">
    <!-- jQuery library -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>

<!-- Latest minified bootstrap js -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

</head>
<body  >
    <div class="wrapper">
        <main>    
            <!-- Encabezado -->
            <header>
                <!--<h1>Taller</h1>-->
                <?php include "includes/header2.php"; ?>
            </header>

            <!--<div id="sidemenu" class="menu-collapsed">-->
            <div id="sidemenu" class="menu-expanded">
                <!-- Header -->
                <div id="header">
                    <div id="title"><span></span> </div>
                    <div id="menu-btn">
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                        <div class="btn-hamburger"></div>
                    </div>
                </div>
                <!--Profile-->
                <!--<div id="profile">
                    <div id="photo"><img src="img/user.png" alt=""></div>
                    <div id="name"><span><?php echo $_SESSION['nombre'];?></span></div>
                    <div id="name"><span><?php echo $_SESSION['iduser']." [ ".$_SESSION['user']." ] ";?></span></div>
                    <div id="name"><span><?php echo "Sucursal: ".$_SESSION['suc'];?></span></div>
                    <div id="name"><span> <?php echo "Rol: ".$_SESSION['rol'];?></span></div>
                </div>-->
                <!--Items-->
                <div id="menu-items">
                    <?php include './includes/navs3.php'?>
                </div>
            </div>

            <div style="height:calc(100%); width:90%; padding-right:15px; padding-left:200px; margin-right:60px; margin-left:60px;margin-top:20px;">

            
            <div style="width:100%;">
                <table border='0' style='width:100%;'>
                    <tr>
                    <td style='text-align:right;'><button class="btn btn-primary btn-sm" onclick="actualizarPagina()"><i class="fa-solid fa-arrows-rotate"></i></button>
                    <button style="margin-right:15px;" class="btn btn-success btn-sm" data-backdrop="static" data-keyboard="false" data-toggle="modal" data-target="#modalForm"><i class="fa-solid fa-circle-plus"></i></button>
                    <input ID="busqueda" type="text" style="width:200px;"placeholder="Captura dato a buscar" onkeydown="if (event.key === 'Enter') buscar()">
                        <button id="btnBusqueda" class="btn btn-primary btn-sm" type="button" onclick="buscar()"><i class="fa-solid fa-magnifying-glass"></i></button>
                    </td>
                </tr>
                </table>
                <div class="table-container" style="width:100%;heigth:100%">
                    <table border='0' style='width:100%;font-size:8pt;'>
                        <thead>
                            <tr>
                                <th style="width:5%;">id</th>
                                <th style="width:10%;">Factura</th>
                                <th style="width:10%;">Fecha</th>
                                <th style="width:30%;">Proveedor</th>
                                <th style="width:15%;">Sucursal</th>
                                <th style="width:15%;">Subtotal</th>
                                <!--<th style='text-align:center;'>Monto</th>-->
                                <th style="width:15%;">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if(empty($_GET['busqueda'])){
                                $busq="";
                            } else{
                                $busq=$_GET['busqueda'];
                            }

                            if(empty($busq)){
                                $b=" order by fechaFactura DESC";
                            } else{

                                $b=" where factura = '".$busq."' or nombre like '%".$busq."%' or sucx like '%".$busq."%' order by fechaFactura DESC";
                            }
                            $sql_registros=mysqli_query($connection,"select count(*) as total_registros from datos_facturas ". $b);
                            
                            $result_registros = mysqli_fetch_array($sql_registros);
                            $total_registros = $result_registros['total_registros'];
                            
                            $por_pagina = 15;
                            if(empty($_GET['pagina'])){
                                $pagina=1;
                            } else{
                                $pagina=$_GET['pagina'];
                            }
                            $desde = ($pagina - 1) * $por_pagina;
                            $total_paginas = ceil($total_registros / $por_pagina);

                            $sql_uniformes=mysqli_query($connection,"select * from datos_facturas". $b);
                            
                            $result_uniformes=mysqli_num_rows($sql_uniformes);
                            $suc=null;
                                if($result_uniformes>0){
                                    while($data=mysqli_fetch_array($sql_uniformes)){
                                        
                                        if($data['sucursal']=='1'){
                                            $suc="TIJUANA";
                                        }else if($data['sucursal']=='2'){
                                            $suc="ENSENADA";
                                        }else if($data['sucursal']=='3'){
                                            $suc="MEXICALI";
                                        }
                                        ?>
                                        <tr>
                                            <td style="text-align:left;padding-left:20px"><?php echo $data['uni_movimientos_idmovimientosUni']?></td>    
                                            <td style="text-align:left;padding-left:20px"><?php echo $data['factura']?></td>    
                                            <td style="text-align:left;padding-left:20px"><?php echo date('d/m/Y',strtotime($data['fechaFactura']));?></td>
                                            <td style="text-align:left;padding-left:20px"><?php echo $data['nombre'];?></td>
                                            <td style="text-align:left;padding-left:20px"><?php echo $suc;?></td>
                                            <td style="text-align:right;padding-right:20px"><?php echo '$ '.number_format($data['subtotal'],2);?></td>
                                            <td><button class="btn btn-primary btn-sm" id="modificar" data-backdrop="static" data-keyboard="false" data-id="<?php echo $data['uni_movimientos_idmovimientosUni'];?>" data-toggle="modal" data-target="#modalFormw"><i class="fa-solid fa-file-pen"></i></button>
                                                <button class="btn btn-danger btn-sm" id="cancelar" data-backdrop="static" data-keyboard="false" data-id="<?php echo $data['uni_movimientos_idmovimientosUni'];?>" data-toggle="modal" data-target="#deleteModal"><i class="fa-solid fa-ban"></i></button>
                                        </td>
                                        </tr>
                                        <?php
                                        
                                    }
                                }

                            ?>
                            

                            <!-- Agrega más filas según sea necesario -->
                        </tbody>
                    </table>
                </div>
                <div class="paginador">
                    <ul><?php
                        $numeroInicio=1;
                        if($pagina!=1){
                        //$numeroInicio=1;
                        
                    ?>
                        
                        <li><a href="?pagina=<?php echo $numeroInicio?>"><i class="fa-solid fa-backward-fast"></i></a></li>
                        <!--<li><a href="?pagina=<?php /*echo $pagina-1*/?>"><<</a></li>-->
                        <?php 
                        }
                            if(($pagina-3)>1){
                                $numeroInicio=$pagina-3;
                            }
                            $numeroFin=$numeroInicio+4;
                            
                            if($numeroFin>$total_paginas){
                                $numeroFin=$total_paginas;
                            }
                            
                            for($i=$numeroInicio;$i<=$numeroFin;$i++){
                                if($i==$pagina){
                                    echo '<li class="pageSelected">'.$i.'</li>';
                                } else{
                                echo '<li><a href="?pagina='.$i.'&busqueda='.$busq.'">'.$i.'</a></li>';
                                }
                            }
                            if($pagina!=$total_paginas){
                                echo '<li><a href="?pagina='.$total_paginas.'&busqueda='.$busq.'"><i class="fa-solid fa-forward-fast"></i></a></li>';
                            }
                        ?>
                                        
                        
                    </ul>
                </div>
            </div>
            

            </div>


            




        </main>
            <!-- Pie de página -->
            <footer>
                <?php include "includes/footer.php"; ?>
            </footer>
    </div>

    <!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirmar Eliminación</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div class="modal-body">
                ¿Estás seguro de que deseas eliminar la factura?
                <p class="statusMsg"></p>    
            </div>
            <div>
                <table style="width:50%;">
                    <tr>
                        <td style="text-align:left;padding-left:40px">Factura:</td>
                        <td><input disabled id="facturaE" type="text"></input><input id="idmovE"  type="hidden"></input></td>
                    </tr>
                    <tr>
                        <td style="text-align:left;padding-left:40px">Fecha:</td>
                        <td><input disabled id="fechaE" type="date"></input></td>
                    </tr>
                    <tr>
                        <td style="text-align:left;padding-left:40px">Proveedor:</td>
                        <td><input disabled id="proveedorE" type="text"></input></td>
                    </tr>
                    <tr>
                        <td style="text-align:left;padding-left:40px">Subtotal:</td>
                        <td><input disabled id="subtotalgE" type="text"></input></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <form method="POST" style="display: inline;">
                <button type="button" class="btn btn-danger submitBtn" onclick="eliminar()">Eliminar</button>    
                <!--<input type="hidden" name="delete_id" id="deleteId">
                    <button type="submit" class="btn btn-danger">Eliminar</button>-->
                </form>
            </div>
        </div>
    </div>
</div>



    <!-- Modal -->
<div class="modal fade" id="modalForm" role="dialog" >
    <div class="modal-dialog" >
        <div class="modal-content" style="width:800px;">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Nueva Compra</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body" >
                <p class="statusMsg"></p>
                <form role="form">
				<table>
				
				<tr>
				
				<td  style="text-align:left;width:200px;">
                <div class="form-group">
                        <label style="font-size: 12px;" for="sucursal">Sucursal:</label>
                        <select style="font-size: 12px;"  class="form-control" id="sucursal">
                        <option value="0">--Selecciona--</option>
                        <option value="1">TIJUANA</option>
                    	<option value="2">ENSENADA</option>
                        <option value="3">MEXICALI</option>
						</select>
                    </div>
                        </td>
                    <td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="proveedor">Proveedor:</label>
                        <select style="font-size: 12px;"  class="form-control"id="proveedor">
                        <option value="0">--Selecciona--</option>
                        <?php
                            $sql=mysqli_query($connection,"select * from uni_proveedor order by nombre ASC");
                            $result=mysqli_num_rows($sql);
					
                            if($result>0){
                            while($data=mysqli_fetch_array($sql)){
                                
                    ?>
                            <option value="<?php echo $data['idproveedorUni']?>"><?php echo $data['nombre']?></option>
                    <?php
                                }
                            }
                    ?>
							
						</select>
                    </div>
				</td>
                
                <td  style="text-align:left;width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="moneda">Moneda:</label>
                        <select style="font-size: 12px;" class="form-control" id="moneda">
                        
                        <option value="1">Pesos</option>
                        <option value="2">Dolares</option>
						</select>
                    </div>
				</td>
                
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="fecha">Fecha:</label>
                        <input style="font-size: 12px;" type="date" class="form-control" id="fecha" />
                    </div>
				</td>
				</tr>
                        </table>
                        <table >
				<tr>
				<td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="factura">Factura:</label>
						<input style="font-size: 12px;" type="text" class="form-control" id="factura" />
                    </div>
				</td>
                <td  style="width:80px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="porcentaje">IVA:</label>
                        <select style="font-size: 12px;"  class="form-control"id="porcentaje" onchange="calcularTotal()">
                            <option value="0">0%</option>
                            <option value="8" selected>8%</option>
                            <option value="16">16%</option>
						</select>
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="iva">IVA</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="iva" value="0.00" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="retencion">Retención</label>
                        <input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="retencion" oninput="calcularTotal()" value="0.00"/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="ubtotalg">Subtotal</label>
                        <input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="subtotalg" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="totalg">Total</label>
                        <input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="totalg" disabled/>
					</div>
				</td>
				</tr>
                        </table>
                        <table>
				<tr>
				<td>
				<div class="form-group">
                <label style="font-size: 12px;" for="uniforme">Uniforme:</label>
                        <select style="font-size: 12px;"  class="form-control" id="uniforme" onchange="inventario()">
                        <option value="0">--Selecciona--</option>
                        <?php
                            $sql=mysqli_query($connection,"select * from datos_uniformes where estado='NUEVO' order by descrip ASC");
                            $result=mysqli_num_rows($sql);
					
                            if($result>0){
                            while($data=mysqli_fetch_array($sql)){
                                
                    ?>
                            <option value="<?php echo $data['iduniforme']?>"><?php echo $data['descrip']?></option>
                    <?php
                                }
                            }
                    ?>
							
						</select>
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="cantidad">Cantidad:</label>
						<input style="font-size: 12px;" type="number" step="1" class="form-control" id="cantidad" />
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="costo">Costo:</label>
						<input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="costo" />
                    </div>
				</td>
				<td>
				<button type="button" class="btn btn-success" onclick="agregarFilaTabla()"><i class="fa-solid fa-plus"></i></button>
				</td>
				</tr>
                        </table>
                        <table>
				<tr>
				<td style="text-align:left;"><strong>Existencias</strong></td>
                        </tr>
                        </table>
                        <table style="width:60%;">
				<tr>
				
				<td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv1">Tijuana</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv1" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv2">Ensenada</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv2" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv3">Mexicali</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv3" disabled/>
					</div>
				</td>
                <td style="width:100px">
				</td>
                
				</tr>
				</table>

                <table class="table" id="tablaDinamica1" name="tablaDinamica1">
                <thead>
                  <tr>
                    <th style="font-size: 12px;width: 10%">id</th>  
                    <th style="font-size: 12px;width: 50%">Uniforme</th>
                    <th style="font-size: 12px;width: 10%">Cantidad</th>
                    <th style="font-size: 12px;width: 10%">Costo</th>
                    <th style="font-size: 12px;width: 10%">Importe</th>
                    <th style="font-size: 12px;width: 10%"></th>
                  </tr>
                </thead>
                <tbody  class="scrollable-tbody">
                  <!-- Las filas se agregarán dinámicamente aquí -->
                </tbody>
              </table>
                    
                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <button type="button" class="btn btn-primary submitBtn" onclick="guardar1()">GUARDAR</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="modalFormm" role="dialog" >
    <div class="modal-dialog" >
        <div class="modal-content" style="width:800px;">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Nueva Compra</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body" >
                <p class="statusMsg"></p>
                <form role="form">
				<table>
				
				<tr>
				
				<td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="proveedor">Proveedor:</label>
                        <select style="font-size: 12px;"  class="form-control"id="proveedor">
                        <option value="0">--Selecciona--</option>
                        <?php
                            $sql=mysqli_query($connection,"select * from uni_proveedor order by nombre ASC");
                            $result=mysqli_num_rows($sql);
					
                            if($result>0){
                            while($data=mysqli_fetch_array($sql)){
                                
                    ?>
                            <option value="<?php echo $data['idproveedorUni']?>"><?php echo $data['nombre']?></option>
                    <?php
                                }
                            }
                    ?>
							
						</select>
                    </div>
				</td>
                
                <td  style="text-align:left;width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="moneda">Moneda:</label>
                        <select style="font-size: 12px;" class="form-control" id="moneda">
                        
                        <option value="1">Pesos</option>
                        <option value="2">Dolares</option>
						</select>
                    </div>
				</td>
                
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="fecha">Fecha:</label>
                        <input style="font-size: 12px;" type="date" class="form-control" id="fecha" />
                    </div>
				</td>
				</tr>
                        </table>
                        <table >
				<tr>
				<td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="factura">Factura:</label>
						<input style="font-size: 12px;" type="text" class="form-control" id="factura" />
                    </div>
				</td>
                <td  style="width:80px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="porcentaje">IVA:</label>
                        <select style="font-size: 12px;"  class="form-control"id="porcentaje" onchange="calcularTotal()">
                            <option value="0">0%</option>
                            <option value="8" selected>8%</option>
                            <option value="16">16%</option>
						</select>
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="iva">IVA</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="iva" value="0.00" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="retencion">Retención</label>
                        <input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="retencion" oninput="calcularTotal()" value="0.00"/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="ubtotalg">Subtotal</label>
                        <input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="subtotalg" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="totalg">Total</label>
                        <input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="totalg" disabled/>
					</div>
				</td>
				</tr>
                        </table>
                        <table>
				<tr>
				<td>
				<div class="form-group">
                <label style="font-size: 12px;" for="uniforme">Uniforme:</label>
                        <select style="font-size: 12px;"  class="form-control" id="uniforme" onchange="inventario()">
                        <option value="0">--Selecciona--</option>
                        <?php
                            $sql=mysqli_query($connection,"select * from datos_uniformes where estado='NUEVO' order by descrip ASC");
                            $result=mysqli_num_rows($sql);
					
                            if($result>0){
                            while($data=mysqli_fetch_array($sql)){
                                
                    ?>
                            <option value="<?php echo $data['iduniforme']?>"><?php echo $data['descrip']?></option>
                    <?php
                                }
                            }
                    ?>
							
						</select>
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="cantidad">Cantidad:</label>
						<input style="font-size: 12px;" type="number" step="1" class="form-control" id="cantidad" />
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="costo">Costo:</label>
						<input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="costo" />
                    </div>
				</td>
				<td>
				<button type="button" class="btn btn-success" onclick="agregarFilaTabla()"><i class="fa-solid fa-plus"></i></button>
				</td>
				</tr>
                        </table>
                        <table>
				<tr>
				<td style="text-align:left;"><strong>Existencias</strong></td>
                        </tr>
                        </table>
                        <table style="width:60%;">
				<tr>
				
				<td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv1">Tijuana</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv1" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv2">Ensenada</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv2" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv3">Mexicali</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv3" disabled/>
					</div>
				</td>
                <td style="width:100px">
				</td>
                
				</tr>
				</table>

                <table class="table" id="tablaDinamica" name="tablaDinamica">
                <thead>
                  <tr>
                    <th style="font-size: 12px;width: 10%">id</th>  
                    <th style="font-size: 12px;width: 45%">Uniforme</th>
                    <th style="font-size: 12px;width: 15%">Cantidad</th>
                    <th style="font-size: 12px;width: 15%">Costo</th>
                    <th style="font-size: 12px;width: 15%">Importe</th>
                  </tr>
                </thead>
                <tbody>
                  <!-- Las filas se agregarán dinámicamente aquí -->
                </tbody>
              </table>
                    
                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <button type="button" class="btn btn-primary submitBtn" onclick="guardar()">GUARDAR</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal view-->
<div class="modal fade" id="modalFormw" role="dialog" >
    <div class="modal-dialog" >
        <div class="modal-content" style="width:800px;">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel" style="font-size: 14px;" >Datos compra</h4>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body" >
                <p class="statusMsgw"></p>
                <form role="form">
				<table>
				
				<tr>

				<td  style="text-align:left;">
				<div class="form-group">
                        <label style="font-size: 12px;" for="proveedorw">Proveedor:</label>
                        <select disabled style="font-size: 12px;"  class="form-control" id="proveedorw">
                        <option value="0">--Selecciona--</option>
                        <?php
                            $sql=mysqli_query($connection,"select * from uni_proveedor order by nombre ASC");
                            $result=mysqli_num_rows($sql);
					
                            if($result>0){
                            while($data=mysqli_fetch_array($sql)){
                                
                    ?>
                            <option value="<?php echo $data['idproveedorUni']?>"><?php echo $data['nombre']?></option>
                    <?php
                                }
                            }
                    ?>
							
						</select>
                    </div>
				</td>
                
                <td  style="text-align:left;width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="monedaw">Moneda:</label>
                        <select disabled style="font-size: 12px;" class="form-control" id="monedaw">
                        
                        <option value="1">Pesos</option>
                        <option value="2">Dolares</option>
						</select>
                    </div>
				</td>
                
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="fechaw">Fecha:</label>
                        <input disabled style="font-size: 12px;" type="date" class="form-control" id="fechaw" />
                    </div>
				</td>
				</tr>
                        </table>
                        <table >
				<tr>
				<td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="facturaw">Factura:</label>
						<input disabled style="font-size: 12px;" type="text" class="form-control" id="facturaw" />
                    </div>
				</td>
                <td  style="width:80px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="porcentajew">IVA:</label>
                        <select disabled style="font-size: 12px;"  class="form-control"id="porcentajew" onchange="calcularTotalw()">
                            <option value="0">0%</option>
                            <option value="8" selected>8%</option>
                            <option value="16">16%</option>
						</select>
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="ivaw">IVA</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="ivaw" value="0.00" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="retencionw">Retención</label>
                        <input disabled style="font-size: 12px;" type="number" step="0.01" class="form-control" id="retencionw" oninput="calcularTotalw()" value="0.00"/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="subtotalgw">Subtotal</label>
                        <input style="font-size: 12px;" type="text" step="0.01" class="form-control" id="subtotalgw" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="totalgw">Total</label>
                        <input style="font-size: 12px;" type="text" step="0.01" class="form-control" id="totalgw" disabled/>
					</div>
				</td>
				</tr>
                        </table>
                        <table>
				<tr>
				<!--<td>
				<div class="form-group">
                <label style="font-size: 12px;" for="uniformew">Uniforme:</label>
                        <select style="font-size: 12px;"  class="form-control" id="uniformew" onchange="inventariow()">
                        <option value="0">--Selecciona--</option>
                        <?php
                            $sql=mysqli_query($connection,"select * from datos_uniformes where estado='NUEVO' order by descrip ASC");
                            $result=mysqli_num_rows($sql);
					
                            if($result>0){
                            while($data=mysqli_fetch_array($sql)){
                                
                    ?>
                            <option value="<?php echo $data['iduniforme']?>"><?php echo $data['descrip']?></option>
                    <?php
                                }
                            }
                    ?>
							
						</select>
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="cantidadw">Cantidad:</label>
						<input style="font-size: 12px;" type="number" step="1" class="form-control" id="cantidadw" />
                    </div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="costow">Costo:</label>
						<input style="font-size: 12px;" type="number" step="0.01" class="form-control" id="costow" />
                    </div>
				</td>
				<td>
				<button type="button" class="btn btn-success" onclick="agregarFilaTablaw()"><i class="fa-solid fa-plus"></i></button>
				</td>-->
				</tr>
                        </table>
                        <!--<table>
				<tr>
				<td style="text-align:left;"><strong>Existencias</strong></td>
                        </tr>
                        </table>
                        <table style="width:60%;">
				<tr>
				
				<td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv1">Tijuana</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv1w" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv2">Ensenada</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv2w" disabled/>
					</div>
				</td>
                <td style="width:100px">
				<div class="form-group">
                        <label style="font-size: 12px;" for="inv3">Mexicali</label>
                        <input style="font-size: 12px;" type="number" class="form-control" id="inv3w" disabled/>
					</div>
				</td>
                <td style="width:100px">
				</td>
                
				</tr>
				</table>-->

                <table class="table" id="tablaDinamicaw" name="tablaDinamicaw">
                <thead>
                  <tr>
                    <th style="font-size: 12px;width: 10%">id</th>  
                    <th style="font-size: 12px;width: 50%">Uniforme</th>
                    <th style="font-size: 12px;width: 10%">Cantidad</th>
                    <th style="font-size: 12px;width: 10%">Costo</th>
                    <th style="font-size: 12px;width: 10%">Importe</th>
                    <th style="font-size: 12px;width: 10%"></th>
                  </tr>
                </thead>
                <tbody>
                  <!-- Las filas se agregarán dinámicamente aquí -->
                </tbody>
              </table>
                    
                </form>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" onclick="javascript:window.location.reload()" data-dismiss="modal" >Cerrar</button>
                <button  disabled type="button" class="btn btn-primary submitBtn" onclick="guardar()">GUARDAR</button>
            </div>
        </div>
    </div>
</div>



    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        const btn = document.querySelector('#menu-btn');
        const menu = document.querySelector('#sidemenu');

        btn.addEventListener('click', e => {
            menu.classList.toggle("menu-expanded");
            menu.classList.toggle("menu-collapsed");

            document.querySelector('body').classList.toggle('body-expanded')
        });
    

        function guardar1() {
    var proveedor = $('#proveedor').val();
    var fecha = $('#fecha').val();
    var factura = $('#factura').val();
    var moneda = $('#moneda').val();
    var iva = $('#iva').val();
    var retencion = $('#retencion').val();
    var subtotal = $('#subtotalg').val();
    var total = $('#totalg').val();
    var sucursal = $('#sucursal').val();
    var datosTabla = [];

    // Recolectar datos de la tabla dinámica manualmente
    $('#tablaDinamica1 tbody tr').each(function() {
        var rowData = {};
        $(this).find('input, select').each(function() {
            var key = $(this).attr('name');
            var value = $(this).val();
            if (key) rowData[key] = value;
        });
        datosTabla.push(rowData);
    });

    // Validación de campos
    if (sucursal == '0' ||proveedor == '0' || !fecha || !factura || iva == '0' || subtotal == '0' || total == '0') {
        $('.statusMsg').html('<span style="color:red;">Favor de llenar todos los campos obligatorios.</span>');
        return;
    }

    if (isNaN(parseFloat(subtotal)) || isNaN(parseFloat(total)) || isNaN(parseFloat(iva))) {
        $('.statusMsg').html('<span style="color:red;">Subtotal, IVA y Total deben ser valores numéricos válidos.</span>');
        return;
    }

    $('.submitBtn').prop('disabled', true);

    // Preparar datos para enviar
    var datos = {
        proveedor: proveedor,
        moneda:moneda,
        fecha: fecha,
        factura: factura,
        iva: iva,
        retencion: retencion,
        subtotal: subtotal,
        total: total,
        sucursal: sucursal,
        datosTabla: JSON.stringify(datosTabla) // Convertir la tabla en JSON
    };

    // Enviar solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'guardar_factura.php', // Cambiar por tu ruta PHP 
        data: datos,
        success: function(response) {
            //alert(response);
            try {
                var data = JSON.parse(response);
                if (data.success) {
                    $('.statusMsg').html('<span style="color:green;">Factura guardada exitosamente.</span>');
                    
                } else {
                    $('.statusMsg').html('<span style="color:red;">Error al guardar la factura: ' + data.message + '</span>');
                    $('.submitBtn').prop('disabled', false); // Reactivar botón si ocurre un error
                }
            } catch (e) {
                $('.statusMsg').html('<span style="color:red;">Error al procesar la respuesta del servidor.</span>');
                $('.submitBtn').prop('disabled', false); // Reactivar botón si ocurre un error
            }
        },
        error: function(xhr, status, error) {
            $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + error + '</span>');
            $('.submitBtn').prop('disabled', false); // Reactivar botón si ocurre un error
        }
    });
}


function guardar() {
        var proveedor = $('#proveedor').val();
        var fecha = $('#fecha').val();
        var factura = $('#factura').val();
        var iva = $('#iva').val();
        var retencion = $('#retencion').val();
        var subtotal = $('#subtotalg').val();
        var total = $('#totalg').val();
        var datosTabla = $("#tablaDinamica1").serialize();

        // Validación de campos
        if (proveedor == '0' || !fecha || !factura || iva == '0' || subtotal == '0' || total == '0') {
            $('.statusMsg').html('<span style="color:red;">Favor de llenar todos los campos obligatorios.</span>');
            return;
        }

        // Verificar valores numéricos
        /*if (isNaN(parseFloat(subtotal)) || isNaN(parseFloat(total)) || isNaN(parseFloat(iva))) {
            $('.statusMsg').html('<span style="color:red;">Subtotal, IVA y Total deben ser valores numéricos válidos.</span>');
            return;
        }*/

        // Preparar datos para enviar
        var datos = {
            proveedor: proveedor,
            fecha: fecha,
            factura: factura,
            iva: iva,
            retencion: retencion,
            subtotal: subtotal,
            total: total,
            datosTabla:datosTabla
            
        };

        // Enviar solicitud AJAX
        $.ajax({
            type: 'POST',
            url: 'guardar_factura.php', // Cambiar por tu ruta PHP
            data: datos,
            success: function(response) {
                    //alert(response);
                try {
                    var data = JSON.parse(response);
                    //alert(data.respuesta);
                    /*if (data.success) {
                        $('.statusMsg').html('<span style="color:green;">Factura guardada exitosamente.</span>');
                    } else {
                        $('.statusMsg').html('<span style="color:red;">Error al guardar la factura: ' + data.message + '</span>');
                    }*/
                } catch (e) {
                    $('.statusMsg').html('<span style="color:red;">Error al procesar la respuesta del servidor.</span>');
                }
            },
            error: function(xhr, status, error) {
                $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + error + '</span>');
            }
        });
}

function actualizarPagina() {
    location.reload();
}

function agregarFilaTabla() {
    var id=$('#uniforme').val();
    if ($('#uniforme').val() == '0') {
        $('.statusMsg').html('<span style="color:red;">Selecciona un uniforme.</span>');
    } else if ($('#cantidad').val() == '0' || $('#cantidad').val() == ''|| $('#cantidad').val() < '0') {
        $('.statusMsg').html('<span style="color:red;">Ingresa la cantidad de piezas.</span>');
    } else if ($('#costo').val() == '0' || $('#costo').val() == '' || $('#costo').val() < '0') {
        $('.statusMsg').html('<span style="color:red;">Ingresa el costo.</span>');
    } else {
        var uniformeYaExiste = false;
        var cantidad=parseFloat($('#cantidad').val());
        var costo=parseFloat($('#costo').val());
        var importe=costo*cantidad;
        
        // Verificar si el uniforme ya existe en la tabla
        $('#tablaDinamica tbody tr').each(function() {
            var valorUniforme = $(this).find('input[name="id[]"]').val();
            if (valorUniforme == $('#uniforme').val()) {
                uniformeYaExiste = true;
                return false; // Salir del each loop
            }
        });

        if (uniformeYaExiste) {
            $('.statusMsg').html('<span style="color:red;">El uniforme ya ha sido agregado.</span>');
        } else {
            $('.statusMsg').html('');
            
            $.ajax({
                type: 'POST',
                url: 'obtener_uniforme.php', // Cambia esto por el nombre de tu archivo PHP
                data: { iduniforme: $('#uniforme').val() },
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        var fila = '<tr>' +
                            '<td style="width:10%"><input disabled style="font-size: 12px;" type="text" class="form-control" name="id[]" value="' + id + '"></td>' +    
                            '<td style="width:50%"><input style="font-size: 12px;" type="text" class="form-control" name="uniforme[]" value="' + data.uniforme + '"></td>' +
                            '<td style="width:10%"><input style="font-size: 12px;text-align:right;" type="text" class="form-control" name="cantidad[]" oninput="calcularImporte(this)" value="'+cantidad+'"></td>' +
                            '<td style="width:10%"><input style="font-size: 12px;text-align:right;" type="text" class="form-control" name="costo[]" oninput="calcularImporte(this)" value="'+costo+'"></td>' +
                            '<td style="width:10%"><input style="font-size: 12px;text-align:right;" type="text" class="form-control" name="importe[]" value="'+importe+'"></td>' +
                            '<td style="width:10%"><button type="button" class="btn btn-danger" onclick="eliminarFilaTabla(this)"><i class="fa-solid fa-eraser"></i></button></td>' +
                            '</tr>';
                        $('#tablaDinamica1 tbody').append(fila);
                        $('#uniforme').val('0');
                        $('#cantidad').val('');
                        $('#costo').val('');
                        calcularTotal();
                    } else {
                        $('.statusMsg').html('<span style="color:red;">Error al obtener los datos del uniforme.</span>');
                    }
                },
                error: function() {
                    $('.statusMsg').html('<span style="color:red;">Error en la solicitud.</span>');
                }
            });
        }
    }
}

function agregarFilaTablaw() {
    var id=$('#uniformew').val();
    if ($('#uniformew').val() == '0') {
        $('.statusMsgw').html('<span style="color:red;">Selecciona un uniforme.</span>');
    } else if ($('#cantidadw').val() == '0' || $('#cantidadw').val() == ''|| $('#cantidadw').val() < '0') {
        $('.statusMsgw').html('<span style="color:red;">Ingresa la cantidad de piezas.</span>');
    } else if ($('#costow').val() == '0' || $('#costow').val() == '' || $('#costow').val() < '0') {
        $('.statusMsgw').html('<span style="color:red;">Ingresa el costo.</span>');
    } else {
        var uniformeYaExiste = false;
        var cantidad=parseFloat($('#cantidadw').val());
        var costo=parseFloat($('#costow').val());
        var importe=costo*cantidad;
        
        // Verificar si el uniforme ya existe en la tabla
        $('#tablaDinamicaw tbody tr').each(function() {
            var valorUniforme = $(this).find('input[name="idw[]"]').val();
            if (valorUniforme == $('#uniformew').val()) {
                uniformeYaExiste = true;
                return false; // Salir del each loop
            }
        });

        if (uniformeYaExiste) {
            $('.statusMsgw').html('<span style="color:red;">El uniforme ya ha sido agregado.</span>');
        } else {
            $('.statusMsgw').html('');
            
            $.ajax({
                type: 'POST',
                url: 'obtener_uniforme.php', // Cambia esto por el nombre de tu archivo PHP
                data: { iduniforme: $('#uniformew').val() },
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        var fila = '<tr>' +
                            '<td style="width:10%"><input disabled style="font-size: 12px;" type="text" class="form-control" name="idw[]" value="' + id + '" size="3"></td>' +    
                            '<td style="width:50%"><input style="font-size: 12px;" type="text" class="form-control" name="uniformew[]" value="' + data.uniforme + '"></td>' +
                            '<td style="width:10%"><input style="font-size: 12px;text-align:right;" type="text" class="form-control" name="cantidadw[]" oninput="calcularImportew(this)" value="'+cantidad+'"></td>' +
                            '<td style="width:10%"><input style="font-size: 12px;text-align:right;" type="text" class="form-control" name="costow[]" oninput="calcularImportew(this)" value="'+costo+'"></td>' +
                            '<td style="width:10%"><input style="font-size: 12px;text-align:right;" type="text" class="form-control" name="importew[]" value="'+importe+'"></td>' +
                            '<td style="width:10%"><button type="button" class="btn btn-danger" onclick="eliminarFilaTablaw(this)"><i class="fa-solid fa-eraser"></i></button></td>' +
                            '</tr>';
                        $('#tablaDinamicaw tbody').append(fila);
                        $('#uniformew').val('0');
                        $('#cantidadw').val('');
                        $('#costow').val('');
                        calcularTotalw();
                    } else {
                        $('.statusMsgw').html('<span style="color:red;">Error al obtener los datos del uniforme.</span>');
                    }
                },
                error: function() {
                    $('.statusMsgw').html('<span style="color:red;">Error en la solicitud.</span>');
                }
            });
        }
    }
}


  // Función para eliminar una fila de la primera tabla
  function eliminarFilaTabla(btn) {
    $(btn).closest('tr').remove();
    calcularImporte(btn);
	
  }

  // Función para eliminar una fila de la primera tabla
  function eliminarFilaTablaw(btn) {
    $(btn).closest('tr').remove();
    calcularImportew(btn);
	
  }

  function inventario(){
    var id=$('#uniforme').val();
    
    $.ajax({
                type: 'POST',
                url: 'obtener_uniforme.php', // Cambia esto por el nombre de tu archivo PHP
                data: { iduniforme: $('#uniforme').val() },
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        $('#inv1').val(data.inv1);
                        $('#inv2').val(data.inv2);
                        $('#inv3').val(data.inv3);
                    } else {
                        $('.statusMsg').html('<span style="color:red;">Error al obtener los inventarios.</span>');
                    }
                },
                error: function() {
                    $('.statusMsg').html('<span style="color:red;">Error en la solicitud.</span>');
                }
            });
  }

  function inventariow(){
    var id=$('#uniformew').val();
    
    $.ajax({
                type: 'POST',
                url: 'obtener_uniforme.php', // Cambia esto por el nombre de tu archivo PHP
                data: { iduniforme:id },
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.success) {
                        $('#inv1w').val(data.inv1);
                        $('#inv2w').val(data.inv2);
                        $('#inv3w').val(data.inv3);
                    } else {
                        $('.statusMsgw').html('<span style="color:red;">Error al obtener los inventarios.</span>');
                    }
                },
                error: function() {
                    $('.statusMsgw').html('<span style="color:red;">Error en la solicitud.</span>');
                }
            });
  }

  function calcularImporte(input) {
            var fila = input.parentNode.parentNode;
            var piezas = fila.querySelector('[name="cantidad[]"]').value;
            var unitario = fila.querySelector('[name="costo[]"]').value;
            var importeInput = fila.querySelector('[name="importe[]"]');
            var importe = parseFloat(piezas) * parseFloat(unitario);

            if (!isNaN(importe)) {
                importeInput.value = importe.toFixed(2);
            } else {
                importeInput.value = "";
            }

            calcularTotal();
        }

        function calcularImportew(input) {
            var fila = input.parentNode.parentNode;
            var piezas = fila.querySelector('[name="cantidadw[]"]').value;
            var unitario = fila.querySelector('[name="costow[]"]').value;
            var importeInput = fila.querySelector('[name="importew[]"]');
            var importe = parseFloat(piezas) * parseFloat(unitario);

            if (!isNaN(importe)) {
                importeInput.value = importe.toFixed(2);
            } else {
                importeInput.value = "";
            }

            calcularTotalw();
        }

        function calcularTotal() {
    var filas = document.querySelectorAll('tr');
    var total = 0;

    filas.forEach(function(fila) {
        var importeInput = fila.querySelector('[name="importe[]"]');
        if (importeInput) {
            var importe = parseFloat(importeInput.value);
            if (!isNaN(importe)) {
                total += importe;
            }
        }
    });
    

    var subtotalInput = document.getElementById('subtotalg');
    var totalInput = document.getElementById('totalg');
    var retencionInput = document.getElementById('retencion');
    var ivaInput = document.getElementById('iva');
    var porcentajeInput = document.getElementById('porcentaje');

    if (subtotalInput && retencionInput && ivaInput && porcentajeInput) {
        var subtotal = total;
        var retencion = parseFloat(retencionInput.value) || 0;
        var porcentaje = parseFloat(porcentajeInput.value) || 0;

        subtotalInput.value = subtotal.toFixed(2);
        var iva = subtotal * (porcentaje/100);
        ivaInput.value = iva.toFixed(2);
        var totalConIva = subtotal + iva - retencion;
        totalInput.value = totalConIva.toFixed(2);
    }
}

function calcularTotalw() {
    var filas = document.querySelectorAll('tr');
    var total = 0;

    filas.forEach(function(fila) {
        var importeInput = fila.querySelector('[name="importew[]"]');
        if (importeInput) {
            var importe = parseFloat(importeInput.value);
            if (!isNaN(importe)) {
                total += importe;
            }
        }
    });
    

    var subtotalInput = document.getElementById('subtotalgw');
    var totalInput = document.getElementById('totalgw');
    var retencionInput = document.getElementById('retencionw');
    var ivaInput = document.getElementById('ivaw');
    var porcentajeInput = document.getElementById('porcentajew');

    if (subtotalInput && retencionInput && ivaInput && porcentajeInput) {
        var subtotal = total;
        var retencion = parseFloat(retencionInput.value) || 0;
        var porcentaje = parseFloat(porcentajeInput.value) || 0;

        subtotalInput.value = subtotal.toFixed(2);
        var iva = subtotal * (porcentaje/100);
        ivaInput.value = iva.toFixed(2);
        var totalConIva = subtotal + iva - retencion;
        totalInput.value = totalConIva.toFixed(2);
    }
}
  
</script>
<script>
    $(document).ready(function(){
        $('#modalFormm').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); // Botón que activó el modal
            var id = button.data('id'); // Extrae el valor data-fact
            var modal = $(this);
            modal.find('#actfact').val(factValue); // Asigna el valor al input
        });
    });
    </script>
<script>
$(document).on('click', '[data-target="#modalFormw"]', function () {
    // Capturamos el valor del atributo `data-id`
    var idMovimiento = $(this).data('id');

    // Realizamos la solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'obtener_factura.php', // Cambia esto por el nombre de tu archivo PHP
        data: { idfactura: idMovimiento },
        success: function(response) {
            //alert(response);
            try {
                var data = JSON.parse(response); // Parsea la respuesta JSON

                // Asignamos los valores obtenidos a los campos del modal
                $('#modalFormw').find('#proveedorw').val(data.proveedor);
                $('#modalFormw').find('#monedaw').val(data.moneda);
                $('#modalFormw').find('#fechaw').val(data.fecha);
                $('#modalFormw').find('#facturaw').val(data.factura);
                $('#modalFormw').find('#ivaw').val(data.iva);
                $('#modalFormw').find('#retencionw').val(data.retencion);
                $('#modalFormw').find('#subtotalgw').val(data.subtotal);
                $('#modalFormw').find('#totalgw').val(data.total);
                $('#tablaDinamicaw tbody').append(data.fila);
                //$('#modalFormw').find('#tabladinamicaw').html(data.fila);

                // Abrimos el modal
                $('#modalFormw').modal('show');
            } catch (e) {
                console.error('Error procesando los datos del servidor: ', e);
                alert('Error al cargar los datos. Intente nuevamente.');
            }
        },
        error: function() {
            alert('Ocurrió un error al obtener los datos. Por favor, inténtelo más tarde.');
        }
    });
});
</script>

<script>
$(document).on('click', '[data-target="#deleteModal"]', function () {
    // Capturamos el valor del atributo `data-id`
    var idMovimiento = $(this).data('id');

    // Realizamos la solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'obtener_factura2.php', // Cambia esto por el nombre de tu archivo PHP
        data: { idfactura: idMovimiento },
        success: function(response) {
            //alert(response);
            try {
                var datax = JSON.parse(response); // Parsea la respuesta JSON

                // Asignamos los valores obtenidos a los campos del modal
                $('#deleteModal').find('#proveedorE').val(datax.proveedor);
                $('#deleteModal').find('#idmovE').val(datax.idmov);
                $('#deleteModal').find('#fechaE').val(datax.fecha);
                $('#deleteModal').find('#facturaE').val(datax.factura);
                $('#deleteModal').find('#subtotalgE').val(datax.subtotal);
                
                // Abrimos el modal
                $('#deleteModal').modal('show');
            } catch (e) {
                console.error('Error procesando los datos del servidor: ', e);
                alert('Error al cargar los datos. Intente nuevamente.');
            }
        },
        error: function() {
            alert('Ocurrió un error al obtener los datos. Por favor, inténtelo más tarde.');
        }
    });
});


function eliminar() {
    var id = $('#idmovE').val();
    

    $('.submitBtn').prop('disabled', true);

    // Preparar datos para enviar
    var datos = {
        id: id
    };

    // Enviar solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'eliminar_factura.php', // Cambiar por tu ruta PHP
        data: datos,
        success: function(response) {
            //alert(response);
            //exit();
            try {
                var data = JSON.parse(response);
                //alert(data.message)
                if (data.success) {
                    $('.statusMsg').html('<span style="color:green;">Factura eliminada exitosamente.</span>');
                    
                } else {
                    $('.statusMsg').html('<span style="color:red;">Error al eliminar la factura: ' + data.message + '</span>');
                    $('.submitBtn').prop('disabled', false); // Reactivar botón si ocurre un error
                }
            } catch (e) {
                //$('.statusMsg').html('<span style="color:red;">Error al procesar la cancelacion .</span>');
                $('.statusMsg').html('<span style="color:red;">Error al eliminar la factura: ' + e + '</span>');
                $('.submitBtn').prop('disabled', false); // Reactivar botón si ocurre un error
            }
        },
        error: function(xhr, status, error) {
            $('.statusMsg').html('<span style="color:red;">Error en la solicitud: ' + error + '</span>');
            $('.submitBtn').prop('disabled', false); // Reactivar botón si ocurre un error
        }
    });
}

function buscar() {
    // Obtiene el valor del input con ID "busqueda"
    const busqueda = document.getElementById("busqueda").value;
    
    // Define la página que deseas agregar (puedes cambiar este valor)
    //const pagina = <?php echo isset($_GET['pagina']) ? json_encode($_GET['pagina']) : '1'; ?>;
    const pagina = '1';
    // Obtén la URL actual
    let url = new URL(window.location.href);

    // Agrega o actualiza los parámetros "buscar" y "pagina"
    url.searchParams.set("busqueda", busqueda);
    url.searchParams.set("pagina", pagina);

    // Redirige a la URL modificada
    window.location.href = url.toString();
}

</script>

</body>
</html>
