<?php
session_start();
include '../conexion.php';

$idfactura = $_POST['idfactura'] ?? null;
$fecha=null;
$numEmp=null;
$idmov=null;
$empleado=null;
$ubicacion=null;

$fila=null;

if (empty($idfactura)) {
    die("El ID de factura no puede estar vacío.");
}

$stmt = $connection->prepare("SELECT * FROM datos_e WHERE idmovimientosUni = ?");
$stmt->bind_param("s", $idfactura);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $fecha=htmlspecialchars($row['fechaMov']);
            $numEmp=htmlspecialchars($row['num_emp']);
            $empleado=htmlspecialchars($row['dato1']);
            $ubicacion=htmlspecialchars($row['dato2']);
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}


$stmt->close();
$connection->close();

$mensaje = array(
    'fecha' => $fecha,
    'numEmp'=>$numEmp,
    'empleado'=>$empleado,
    'ubicacion'=>$ubicacion,
    'idmov'=>$idfactura

);
    
echo json_encode($mensaje);		
?>