<?php
session_start();
include '../conexion.php';

$idUsuario = $_POST['idUsuario'] ?? null;

if (empty($idUsuario)) {
    die("El ID de usuario no puede estar vacío.");
}

$stmt = $connection->prepare("SELECT * FROM uni_user WHERE idUser = ?");
$stmt->bind_param("s", $idUsuario);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $nombre=htmlspecialchars($row['Nombre']);
            $pass=htmlspecialchars($row['pass']);
            $usuario=htmlspecialchars($row['usuario']);
            $correo=htmlspecialchars($row['correo']);
            $tipo=htmlspecialchars($row['tipo']);
            $ubicacion=htmlspecialchars($row['ubicacion']);
            $estado=htmlspecialchars($row['estado']);

        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}



$mensaje = array(
    'nombre' => $nombre,
    'pass'=>$pass,
    'usuario'=>$usuario,
    'correo'=>$correo,
    'tipo'=>$tipo,
    'ubicacion'=>$ubicacion,
    'estado'=>$estado
    
);
    
echo json_encode($mensaje);		
?>